/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.tools.ArrayUtils;

public class PropBoolChannel
extends Propagator<Variable> {
    private int n;
    private int offSet;
    private BoolVar[] bools;
    private SetVar set;
    private ISetDeltaMonitor sdm;
    private IntProcedure setForced;
    private IntProcedure setRemoved;

    public PropBoolChannel(SetVar setVar, BoolVar[] boolVars, int offSet) {
        super(ArrayUtils.append(boolVars, {setVar}), PropagatorPriority.UNARY, true);
        this.n = boolVars.length;
        this.bools = new BoolVar[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.bools[i] = (BoolVar)this.vars[i];
        }
        this.set = (SetVar)this.vars[this.n];
        this.sdm = this.set.monitorDelta(this);
        this.offSet = offSet;
        this.setForced = element -> this.bools[element - offSet].setToTrue(this.aCause);
        this.setRemoved = element -> this.bools[element - offSet].setToFalse(this.aCause);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            if (this.bools[i].isInstantiated()) {
                if (this.bools[i].getValue() == 0) {
                    this.set.removeFromEnvelope(i + this.offSet, this.aCause);
                    continue;
                }
                this.set.addToKernel(i + this.offSet, this.aCause);
                continue;
            }
            if (this.set.envelopeContains(i + this.offSet)) continue;
            this.bools[i].setToFalse(this.aCause);
        }
        int j = this.set.getEnvelopeFirst();
        while (j != Integer.MIN_VALUE) {
            if (j < this.offSet || j >= this.n + this.offSet) {
                this.set.removeFromEnvelope(j, this.aCause);
            }
            j = this.set.getEnvelopeNext();
        }
        j = this.set.getKernelFirst();
        while (j != Integer.MIN_VALUE) {
            this.bools[j - this.offSet].setToTrue(this.aCause);
            j = this.set.getKernelNext();
        }
        this.sdm.unfreeze();
    }

    @Override
    public void propagate(int i, int mask) throws ContradictionException {
        if (i < this.n) {
            if (this.bools[i].getValue() == 0) {
                this.set.removeFromEnvelope(i + this.offSet, this.aCause);
            } else {
                this.set.addToKernel(i + this.offSet, this.aCause);
            }
        } else {
            this.sdm.freeze();
            this.sdm.forEach(this.setForced, SetEventType.ADD_TO_KER);
            this.sdm.forEach(this.setRemoved, SetEventType.REMOVE_FROM_ENVELOPE);
            this.sdm.unfreeze();
        }
    }

    @Override
    public ESat isEntailed() {
        int j = this.set.getKernelFirst();
        while (j != Integer.MIN_VALUE) {
            int i = j - this.offSet;
            if (i < 0 || i >= this.bools.length || this.bools[i].isInstantiatedTo(0)) {
                return ESat.FALSE;
            }
            j = this.set.getKernelNext();
        }
        for (int i = 0; i < this.n; ++i) {
            if (!this.bools[i].isInstantiatedTo(1) || this.set.envelopeContains(i + this.offSet)) continue;
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = this.bools.length;
            BoolVar[] aVars = new BoolVar[size];
            for (int i = 0; i < size; ++i) {
                this.bools[i].duplicate(solver, identitymap);
                aVars[i] = (BoolVar)identitymap.get(this.bools[i]);
            }
            this.set.duplicate(solver, identitymap);
            SetVar S = (SetVar)identitymap.get(this.set);
            identitymap.put(this, new PropBoolChannel(S, aVars, this.offSet));
        }
    }
}

