/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;

public class PropCardinality
extends Propagator<Variable> {
    private IntVar card;
    private SetVar set;

    public PropCardinality(SetVar setVar, IntVar cardinality) {
        super(new Variable[]{setVar, cardinality}, PropagatorPriority.BINARY, false);
        this.set = (SetVar)this.vars[0];
        this.card = (IntVar)this.vars[1];
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == 0) {
            return SetEventType.all();
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        block3: {
            int c;
            int e;
            block4: {
                int k = this.set.getKernelSize();
                this.card.updateLowerBound(k, this.aCause);
                e = this.set.getEnvelopeSize();
                this.card.updateUpperBound(e, this.aCause);
                if (!this.card.isInstantiated()) break block3;
                c = this.card.getValue();
                if (c != k) break block4;
                int j = this.set.getEnvelopeFirst();
                while (j != Integer.MIN_VALUE) {
                    if (!this.set.kernelContains(j)) {
                        this.set.removeFromEnvelope(j, this.aCause);
                    }
                    j = this.set.getEnvelopeNext();
                }
                break block3;
            }
            if (c != e) break block3;
            int j = this.set.getEnvelopeFirst();
            while (j != Integer.MIN_VALUE) {
                this.set.addToKernel(j, this.aCause);
                j = this.set.getEnvelopeNext();
            }
        }
    }

    @Override
    public ESat isEntailed() {
        int k = this.set.getKernelSize();
        int e = this.set.getEnvelopeSize();
        if (k > this.card.getUB() || e < this.card.getLB()) {
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            this.set.duplicate(solver, identitymap);
            SetVar S = (SetVar)identitymap.get(this.set);
            this.card.duplicate(solver, identitymap);
            IntVar C = (IntVar)identitymap.get(this.card);
            identitymap.put(this, new PropCardinality(S, C));
        }
    }
}

