/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropElement
extends Propagator<Variable> {
    private TIntArrayList constructiveDisjunction;
    private IntVar index;
    private SetVar set;
    private SetVar[] array;
    private int offSet;

    public PropElement(IntVar index, SetVar[] array, int offSet, SetVar set) {
        super(ArrayUtils.append(array, {set, index}), PropagatorPriority.LINEAR, false);
        this.index = (IntVar)this.vars[this.vars.length - 1];
        this.set = (SetVar)this.vars[this.vars.length - 2];
        this.array = new SetVar[array.length];
        for (int i = 0; i < array.length; ++i) {
            this.array[i] = (SetVar)this.vars[i];
        }
        this.offSet = offSet;
        this.constructiveDisjunction = new TIntArrayList();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.index.updateLowerBound(this.offSet, this.aCause);
        this.index.updateUpperBound(this.array.length - 1 + this.offSet, this.aCause);
        if (this.index.isInstantiated()) {
            this.setEq(this.set, this.array[this.index.getValue() - this.offSet]);
            this.setEq(this.array[this.index.getValue() - this.offSet], this.set);
        } else {
            int ub = this.index.getUB();
            boolean noEmptyKer = true;
            int i = this.index.getLB();
            while (i <= ub) {
                if (this.disjoint(this.set, this.array[i - this.offSet]) || this.disjoint(this.array[i - this.offSet], this.set)) {
                    this.index.removeValue(i, this.aCause);
                } else if (this.array[i - this.offSet].getKernelSize() == 0) {
                    noEmptyKer = false;
                }
                i = this.index.nextValue(i);
            }
            ub = this.index.getUB();
            if (noEmptyKer) {
                int j;
                int cd;
                this.constructiveDisjunction.clear();
                SetVar v = this.array[this.index.getLB() - this.offSet];
                int j2 = v.getKernelFirst();
                while (j2 != Integer.MIN_VALUE) {
                    if (!this.set.kernelContains(j2)) {
                        this.constructiveDisjunction.add(j2);
                    }
                    j2 = v.getKernelNext();
                }
                block2: for (cd = this.constructiveDisjunction.size() - 1; cd >= 0; --cd) {
                    j = this.constructiveDisjunction.get(cd);
                    int i2 = this.index.nextValue(this.index.getLB());
                    while (i2 <= ub) {
                        if (!this.array[i2 - this.offSet].kernelContains(j)) {
                            this.constructiveDisjunction.remove(j);
                            continue block2;
                        }
                        i2 = this.index.nextValue(i2);
                    }
                }
                for (cd = this.constructiveDisjunction.size() - 1; cd >= 0; --cd) {
                    j = this.constructiveDisjunction.get(cd);
                    this.set.addToKernel(j, this.aCause);
                }
            }
            if (!this.set.isInstantiated()) {
                int j = this.set.getEnvelopeFirst();
                while (j != Integer.MIN_VALUE) {
                    boolean valueExists = false;
                    int i3 = this.index.getLB();
                    while (i3 <= ub) {
                        if (this.array[i3 - this.offSet].envelopeContains(j)) {
                            valueExists = true;
                            break;
                        }
                        i3 = this.index.nextValue(i3);
                    }
                    if (!valueExists) {
                        this.set.removeFromEnvelope(j, this.aCause);
                    }
                    j = this.set.getEnvelopeNext();
                }
            }
        }
    }

    private void setEq(SetVar s1, SetVar s2) throws ContradictionException {
        int j = s2.getKernelFirst();
        while (j != Integer.MIN_VALUE) {
            s1.addToKernel(j, this.aCause);
            j = s2.getKernelNext();
        }
        j = s1.getEnvelopeFirst();
        while (j != Integer.MIN_VALUE) {
            if (!s2.envelopeContains(j)) {
                s1.removeFromEnvelope(j, this.aCause);
            }
            j = s1.getEnvelopeNext();
        }
    }

    private boolean disjoint(SetVar s1, SetVar s2) {
        int j = s2.getKernelFirst();
        while (j != Integer.MIN_VALUE) {
            if (!s1.envelopeContains(j)) {
                return true;
            }
            j = s2.getKernelNext();
        }
        return false;
    }

    @Override
    public ESat isEntailed() {
        if (this.index.isInstantiated()) {
            if (this.disjoint(this.set, this.array[this.index.getValue() - this.offSet]) || this.disjoint(this.array[this.index.getValue() - this.offSet], this.set)) {
                return ESat.FALSE;
            }
            if (this.set.isInstantiated() && this.array[this.index.getValue() - this.offSet].isInstantiated()) {
                return ESat.TRUE;
            }
            return ESat.UNDEFINED;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = this.vars.length - 2;
            SetVar[] aVars = new SetVar[size];
            for (int i = 0; i < size; ++i) {
                this.vars[i].duplicate(solver, identitymap);
                aVars[i] = (SetVar)identitymap.get(this.vars[i]);
            }
            this.set.duplicate(solver, identitymap);
            SetVar S = (SetVar)identitymap.get(this.set);
            this.index.duplicate(solver, identitymap);
            IntVar I = (IntVar)identitymap.get(this.index);
            identitymap.put(this, new PropElement(I, aVars, this.offSet, S));
        }
    }
}

