/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;

public class PropIntBoundedMemberSet
extends Propagator<Variable> {
    private IntVar iv;
    private SetVar set;
    private int watchLit1;
    private int watchLit2;

    public PropIntBoundedMemberSet(SetVar setVar, IntVar intVar) {
        super(new Variable[]{setVar, intVar}, PropagatorPriority.BINARY, true);
        assert (!intVar.hasEnumeratedDomain());
        this.set = (SetVar)this.vars[0];
        this.iv = (IntVar)this.vars[1];
        this.watchLit1 = this.iv.getLB();
        this.watchLit2 = this.iv.nextValue(this.watchLit1);
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == 0) {
            return SetEventType.REMOVE_FROM_ENVELOPE.getMask();
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int maxVal;
        if (this.iv.isInstantiated()) {
            this.set.addToKernel(this.iv.getValue(), this.aCause);
            this.setPassive();
            return;
        }
        int minVal = maxVal = this.set.getEnvelopeFirst();
        int j = maxVal;
        while (j != Integer.MIN_VALUE) {
            maxVal = j;
            j = this.set.getEnvelopeNext();
        }
        this.iv.updateUpperBound(maxVal, this.aCause);
        this.iv.updateLowerBound(minVal, this.aCause);
        minVal = this.iv.getLB();
        maxVal = this.iv.getUB();
        while (minVal <= maxVal && !this.set.envelopeContains(minVal)) {
            this.iv.updateLowerBound(++minVal, this);
        }
        while (minVal <= maxVal && !this.set.envelopeContains(maxVal)) {
            this.iv.updateUpperBound(--maxVal, this);
        }
        if (this.iv.isInstantiated()) {
            this.set.addToKernel(this.iv.getValue(), this.aCause);
            this.setPassive();
            return;
        }
        int i = this.set.getEnvelopeFirst();
        int wl = 0;
        int cnt = 0;
        while (i != Integer.MIN_VALUE && wl < 2) {
            if (!this.iv.contains(i)) {
                ++cnt;
            } else {
                this.watchLit2 = this.watchLit1;
                this.watchLit1 = i;
                ++wl;
            }
            i = this.set.getEnvelopeNext();
        }
        if (cnt == this.set.getEnvelopeSize()) {
            this.contradiction(this.iv, "Inconsistent");
        } else if (cnt == this.set.getEnvelopeSize() - 1) {
            this.setWatchLiteral(this.watchLit1);
        }
    }

    @Override
    public void propagate(int i, int mask) throws ContradictionException {
        if (i == 1) {
            if (this.iv.isInstantiated()) {
                this.set.addToKernel(this.iv.getValue(), this.aCause);
                this.setPassive();
            } else if (!this.iv.contains(this.watchLit1)) {
                this.setWatchLiteral(this.watchLit2);
            } else if (!this.iv.contains(this.watchLit2)) {
                this.setWatchLiteral(this.watchLit1);
            }
        } else if (!this.set.envelopeContains(this.watchLit1)) {
            this.setWatchLiteral(this.watchLit2);
        } else if (!this.set.envelopeContains(this.watchLit2)) {
            this.setWatchLiteral(this.watchLit1);
        }
    }

    private void setWatchLiteral(int otherWL) throws ContradictionException {
        int i = this.set.getEnvelopeFirst();
        int cnt = 0;
        while (i != Integer.MIN_VALUE) {
            if (!this.iv.contains(i)) {
                ++cnt;
            } else if (i != otherWL) {
                this.watchLit1 = i;
                this.watchLit2 = otherWL;
                return;
            }
            i = this.set.getEnvelopeNext();
        }
        if (cnt == this.set.getEnvelopeSize()) {
            this.contradiction(this.iv, "Inconsistent");
        }
        this.set.addToKernel(otherWL, this.aCause);
        this.iv.instantiateTo(otherWL, this.aCause);
        this.setPassive();
    }

    @Override
    public ESat isEntailed() {
        int i;
        if (this.iv.isInstantiated()) {
            if (!this.set.envelopeContains(this.iv.getValue())) {
                return ESat.FALSE;
            }
            if (this.set.kernelContains(this.iv.getValue())) {
                return ESat.TRUE;
            }
            return ESat.UNDEFINED;
        }
        int lb = this.iv.getLB();
        int ub = this.iv.getUB();
        boolean all = true;
        for (i = lb; i <= ub; ++i) {
            if (this.set.kernelContains(i)) continue;
            all = false;
            break;
        }
        if (all) {
            return ESat.TRUE;
        }
        for (i = lb; i <= ub; ++i) {
            if (!this.set.envelopeContains(i)) continue;
            return ESat.UNDEFINED;
        }
        return ESat.FALSE;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            this.set.duplicate(solver, identitymap);
            SetVar S = (SetVar)identitymap.get(this.set);
            this.iv.duplicate(solver, identitymap);
            IntVar I = (IntVar)identitymap.get(this.iv);
            identitymap.put(this, new PropIntBoundedMemberSet(S, I));
        }
    }
}

