/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.tools.ArrayUtils;

public class PropIntChannel
extends Propagator<Variable> {
    private int nInts;
    private int nSets;
    private int idx;
    private SetVar[] sets;
    private IntVar[] ints;
    private int offSet1;
    private int offSet2;
    private ISetDeltaMonitor[] sdm;
    private IIntDeltaMonitor[] idm;
    private IntProcedure elementForced;
    private IntProcedure elementRemoved;
    private IntProcedure valRem;

    public PropIntChannel(SetVar[] setsV, IntVar[] intsV, int offSet1, int offSet2) {
        super(ArrayUtils.append(setsV, intsV), PropagatorPriority.LINEAR, true);
        int i;
        this.nSets = setsV.length;
        this.nInts = intsV.length;
        this.sets = new SetVar[this.nSets];
        this.ints = new IntVar[this.nInts];
        this.idm = new IIntDeltaMonitor[this.nInts];
        this.sdm = new ISetDeltaMonitor[this.nSets];
        this.offSet1 = offSet1;
        this.offSet2 = offSet2;
        for (i = 0; i < this.nInts; ++i) {
            this.ints[i] = (IntVar)this.vars[i + this.nSets];
            this.idm[i] = this.ints[i].monitorDelta(this);
        }
        for (i = 0; i < this.nSets; ++i) {
            this.sets[i] = (SetVar)this.vars[i];
            this.sdm[i] = this.sets[i].monitorDelta(this);
        }
        this.elementForced = element -> this.ints[element - offSet2].instantiateTo(this.idx, this.aCause);
        this.elementRemoved = element -> this.ints[element - offSet2].removeValue(this.idx, this.aCause);
        this.valRem = element -> this.sets[element - offSet1].removeFromEnvelope(this.idx, this.aCause);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        for (i = 0; i < this.nInts; ++i) {
            this.ints[i].updateLowerBound(this.offSet1, this.aCause);
            this.ints[i].updateUpperBound(this.nSets - 1 + this.offSet1, this.aCause);
        }
        for (i = 0; i < this.nInts; ++i) {
            int ub = this.ints[i].getUB();
            int j = this.ints[i].getLB();
            while (j <= ub) {
                if (!this.sets[j - this.offSet1].envelopeContains(i + this.offSet2)) {
                    this.ints[i].removeValue(j, this.aCause);
                }
                j = this.ints[i].nextValue(j);
            }
            if (!this.ints[i].isInstantiated()) continue;
            this.sets[this.ints[i].getValue() - this.offSet1].addToKernel(i + this.offSet2, this.aCause);
        }
        for (i = 0; i < this.nSets; ++i) {
            int j = this.sets[i].getEnvelopeFirst();
            while (j != Integer.MIN_VALUE) {
                if (j < this.offSet2 || j > this.nInts - 1 + this.offSet2 || !this.ints[j - this.offSet2].contains(i + this.offSet1)) {
                    this.sets[i].removeFromEnvelope(j, this.aCause);
                }
                j = this.sets[i].getEnvelopeNext();
            }
            j = this.sets[i].getKernelFirst();
            while (j != Integer.MIN_VALUE) {
                this.ints[j - this.offSet2].instantiateTo(i + this.offSet1, this.aCause);
                j = this.sets[i].getKernelNext();
            }
        }
        for (i = 0; i < this.nSets; ++i) {
            this.sdm[i].unfreeze();
        }
        for (i = 0; i < this.nInts; ++i) {
            this.idm[i].unfreeze();
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.idx = idxVarInProp;
        if (this.idx < this.nSets) {
            this.idx += this.offSet1;
            this.sdm[idxVarInProp].freeze();
            this.sdm[idxVarInProp].forEach(this.elementForced, SetEventType.ADD_TO_KER);
            this.sdm[idxVarInProp].forEach(this.elementRemoved, SetEventType.REMOVE_FROM_ENVELOPE);
            this.sdm[idxVarInProp].unfreeze();
        } else {
            this.idx -= this.nSets;
            if (this.ints[this.idx].isInstantiated()) {
                this.sets[this.ints[this.idx].getValue() - this.offSet1].addToKernel(this.idx + this.offSet2, this.aCause);
            }
            this.idx += this.offSet2;
            this.idm[idxVarInProp - this.nSets].freeze();
            this.idm[idxVarInProp - this.nSets].forEachRemVal(this.valRem);
            this.idm[idxVarInProp - this.nSets].unfreeze();
        }
    }

    @Override
    public ESat isEntailed() {
        int i;
        for (i = 0; i < this.nInts; ++i) {
            int val;
            if (!this.ints[i].isInstantiated() || (val = this.ints[i].getValue()) >= this.offSet1 && val < this.nSets + this.offSet1 && this.sets[val - this.offSet1].envelopeContains(i + this.offSet2)) continue;
            return ESat.FALSE;
        }
        for (i = 0; i < this.nSets; ++i) {
            int j = this.sets[i].getKernelFirst();
            while (j != Integer.MIN_VALUE) {
                if (j < this.offSet2 || j >= this.nInts + this.offSet2 || !this.ints[j - this.offSet2].contains(i + this.offSet1)) {
                    return ESat.FALSE;
                }
                j = this.sets[i].getKernelNext();
            }
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = this.nSets;
            SetVar[] svars = new SetVar[size];
            for (int i = 0; i < size; ++i) {
                this.vars[i].duplicate(solver, identitymap);
                svars[i] = (SetVar)identitymap.get(this.vars[i]);
            }
            int si = this.nInts;
            IntVar[] ivars = new IntVar[si];
            for (int i = 0; i < si; ++i) {
                this.ints[i].duplicate(solver, identitymap);
                ivars[i] = (IntVar)identitymap.get(this.ints[i]);
            }
            identitymap.put(this, new PropIntChannel(svars, ivars, this.offSet1, this.offSet2));
        }
    }
}

