/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.procedure.IntProcedure;

public class PropIntEnumMemberSet
extends Propagator<Variable> {
    private IntVar iv;
    private SetVar set;
    private ISetDeltaMonitor sdm;
    private IntProcedure elemRem;

    public PropIntEnumMemberSet(SetVar setVar, IntVar intVar) {
        super(new Variable[]{setVar, intVar}, PropagatorPriority.BINARY, true);
        assert (intVar.hasEnumeratedDomain()) : this.iv.toString() + " does not an enumerated domain";
        this.set = (SetVar)this.vars[0];
        this.iv = (IntVar)this.vars[1];
        this.sdm = this.set.monitorDelta(this);
        this.elemRem = i -> this.iv.removeValue(i, this.aCause);
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == 0) {
            return SetEventType.REMOVE_FROM_ENVELOPE.getMask();
        }
        return IntEventType.INSTANTIATE.getMask();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.iv.isInstantiated()) {
            this.set.addToKernel(this.iv.getValue(), this.aCause);
            this.setPassive();
            return;
        }
        int ub = this.iv.getUB();
        int i = this.iv.getLB();
        while (i <= ub) {
            if (!this.set.envelopeContains(i)) {
                this.iv.removeValue(i, this.aCause);
            }
            i = this.iv.nextValue(i);
        }
        if (this.iv.isInstantiated()) {
            this.set.addToKernel(this.iv.getValue(), this.aCause);
            this.setPassive();
        }
        this.sdm.unfreeze();
    }

    @Override
    public void propagate(int i, int mask) throws ContradictionException {
        if (i == 0) {
            this.sdm.freeze();
            this.sdm.forEach(this.elemRem, SetEventType.REMOVE_FROM_ENVELOPE);
            this.sdm.unfreeze();
        }
        if (this.iv.isInstantiated()) {
            this.set.addToKernel(this.iv.getValue(), this.aCause);
            this.setPassive();
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.iv.isInstantiated()) {
            if (!this.set.envelopeContains(this.iv.getValue())) {
                return ESat.FALSE;
            }
            if (this.set.kernelContains(this.iv.getValue())) {
                return ESat.TRUE;
            }
            return ESat.UNDEFINED;
        }
        int minVal = this.iv.getLB();
        int maxVal = this.iv.getUB();
        boolean all = true;
        int i = minVal;
        while (i <= maxVal) {
            if (!this.set.kernelContains(i)) {
                all = false;
                break;
            }
            i = this.iv.nextValue(i);
        }
        if (all) {
            return ESat.TRUE;
        }
        i = minVal;
        while (i <= maxVal) {
            if (this.set.envelopeContains(i)) {
                return ESat.UNDEFINED;
            }
            i = this.iv.nextValue(i);
        }
        return ESat.FALSE;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            this.set.duplicate(solver, identitymap);
            SetVar S = (SetVar)identitymap.get(this.set);
            this.iv.duplicate(solver, identitymap);
            IntVar I = (IntVar)identitymap.get(this.iv);
            identitymap.put(this, new PropIntEnumMemberSet(S, I));
        }
    }
}

