/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.tools.ArrayUtils;

public class PropIntersection
extends Propagator<SetVar> {
    private int k;
    private ISetDeltaMonitor[] sdm;
    private IntProcedure intersectionForced;
    private IntProcedure intersectionRemoved;
    private IntProcedure setForced;
    private IntProcedure setRemoved;

    public PropIntersection(SetVar[] sets, SetVar intersection) {
        super((Variable[])ArrayUtils.append(sets, {intersection}), PropagatorPriority.LINEAR, true);
        this.k = sets.length;
        this.sdm = new ISetDeltaMonitor[this.k + 1];
        for (int i = 0; i <= this.k; ++i) {
            this.sdm[i] = ((SetVar[])this.vars)[i].monitorDelta(this);
        }
        this.intersectionForced = element -> {
            for (int i = 0; i < this.k; ++i) {
                ((SetVar[])this.vars)[i].addToKernel(element, this.aCause);
            }
        };
        this.intersectionRemoved = element -> {
            int mate = -1;
            for (int i = 0; i < this.k; ++i) {
                if (((SetVar[])this.vars)[i].envelopeContains(element)) {
                    if (((SetVar[])this.vars)[i].kernelContains(element)) continue;
                    if (mate == -1) {
                        mate = i;
                        continue;
                    }
                    mate = -2;
                    break;
                }
                mate = -2;
                break;
            }
            if (mate == -1) {
                this.contradiction(((SetVar[])this.vars)[this.k], "");
            } else if (mate != -2) {
                ((SetVar[])this.vars)[mate].removeFromEnvelope(element, this.aCause);
            }
        };
        this.setForced = element -> {
            boolean allKer = true;
            for (int i = 0; i < this.k; ++i) {
                if (!((SetVar[])this.vars)[i].envelopeContains(element)) {
                    ((SetVar[])this.vars)[this.k].removeFromEnvelope(element, this.aCause);
                    allKer = false;
                    break;
                }
                if (((SetVar[])this.vars)[i].kernelContains(element)) continue;
                allKer = false;
            }
            if (allKer) {
                ((SetVar[])this.vars)[this.k].addToKernel(element, this.aCause);
            }
        };
        this.setRemoved = element -> ((SetVar[])this.vars)[this.k].removeFromEnvelope(element, this.aCause);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        SetVar intersection = ((SetVar[])this.vars)[this.k];
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            int j = ((SetVar[])this.vars)[0].getKernelFirst();
            while (j != Integer.MIN_VALUE) {
                boolean all = true;
                for (int i = 1; i < this.k; ++i) {
                    if (((SetVar[])this.vars)[i].kernelContains(j)) continue;
                    all = false;
                    break;
                }
                if (all) {
                    intersection.addToKernel(j, this.aCause);
                }
                j = ((SetVar[])this.vars)[0].getKernelNext();
            }
            j = intersection.getEnvelopeFirst();
            while (j != Integer.MIN_VALUE) {
                int i;
                if (intersection.kernelContains(j)) {
                    for (i = 0; i < this.k; ++i) {
                        ((SetVar[])this.vars)[i].addToKernel(j, this.aCause);
                    }
                } else {
                    for (i = 0; i < this.k; ++i) {
                        if (((SetVar[])this.vars)[i].envelopeContains(j)) continue;
                        intersection.removeFromEnvelope(j, this.aCause);
                        break;
                    }
                }
                j = intersection.getEnvelopeNext();
            }
            for (int i = 0; i <= this.k; ++i) {
                this.sdm[i].unfreeze();
            }
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.sdm[idxVarInProp].freeze();
        if (idxVarInProp < this.k) {
            this.sdm[idxVarInProp].forEach(this.setForced, SetEventType.ADD_TO_KER);
            this.sdm[idxVarInProp].forEach(this.setRemoved, SetEventType.REMOVE_FROM_ENVELOPE);
        } else {
            this.sdm[idxVarInProp].forEach(this.intersectionForced, SetEventType.ADD_TO_KER);
            this.sdm[idxVarInProp].forEach(this.intersectionRemoved, SetEventType.REMOVE_FROM_ENVELOPE);
        }
        this.sdm[idxVarInProp].unfreeze();
    }

    @Override
    public ESat isEntailed() {
        int j = ((SetVar[])this.vars)[this.k].getKernelFirst();
        while (j != Integer.MIN_VALUE) {
            for (int i = 0; i < this.k; ++i) {
                if (((SetVar[])this.vars)[i].envelopeContains(j)) continue;
                return ESat.FALSE;
            }
            j = ((SetVar[])this.vars)[this.k].getKernelNext();
        }
        j = ((SetVar[])this.vars)[0].getKernelFirst();
        while (j != Integer.MIN_VALUE) {
            if (!((SetVar[])this.vars)[this.k].envelopeContains(j)) {
                boolean all = true;
                for (int i = 1; i < this.k; ++i) {
                    if (((SetVar[])this.vars)[i].kernelContains(j)) continue;
                    all = false;
                    break;
                }
                if (all) {
                    return ESat.FALSE;
                }
            }
            j = ((SetVar[])this.vars)[0].getKernelNext();
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = this.k;
            SetVar[] svars = new SetVar[size];
            for (int i = 0; i < size; ++i) {
                ((SetVar[])this.vars)[i].duplicate(solver, identitymap);
                svars[i] = (SetVar)identitymap.get(((SetVar[])this.vars)[i]);
            }
            ((SetVar[])this.vars)[this.k].duplicate(solver, identitymap);
            SetVar I = (SetVar)identitymap.get(((SetVar[])this.vars)[this.k]);
            identitymap.put(this, new PropIntersection(svars, I));
        }
    }
}

