/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import gnu.trove.map.hash.THashMap;
import java.util.Arrays;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.tools.ArrayUtils;

public class PropInverse
extends Propagator<SetVar> {
    private int n;
    private int n2;
    private int idx;
    private SetVar[] sets;
    private SetVar[] invsets;
    private SetVar[] toFilter;
    private int offSet1;
    private int offSet2;
    private int offSet;
    private ISetDeltaMonitor[] sdm;
    private IntProcedure elementForced;
    private IntProcedure elementRemoved;

    public PropInverse(SetVar[] sets, SetVar[] invsets, int offSet1, int offSet2) {
        super((Variable[])ArrayUtils.append(sets, invsets), PropagatorPriority.LINEAR, true);
        this.n = sets.length;
        this.n2 = invsets.length;
        this.offSet1 = offSet1;
        this.offSet2 = offSet2;
        this.sets = (SetVar[])Arrays.copyOfRange(this.vars, 0, sets.length);
        this.invsets = (SetVar[])Arrays.copyOfRange(this.vars, sets.length, ((SetVar[])this.vars).length);
        this.sdm = new ISetDeltaMonitor[this.n + this.n2];
        for (int i = 0; i < this.n + this.n2; ++i) {
            this.sdm[i] = ((SetVar[])this.vars)[i].monitorDelta(this);
        }
        this.elementForced = element -> this.toFilter[element - this.offSet].addToKernel(this.idx, this.aCause);
        this.elementRemoved = element -> this.toFilter[element - this.offSet].removeFromEnvelope(this.idx, this.aCause);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int j;
        int i;
        for (i = 0; i < this.n; ++i) {
            j = this.sets[i].getEnvelopeFirst();
            while (j != Integer.MIN_VALUE) {
                if (j < this.offSet1 || j >= this.n2 + this.offSet1 || !this.invsets[j - this.offSet2].envelopeContains(i + this.offSet1)) {
                    this.sets[i].removeFromEnvelope(j, this.aCause);
                }
                j = this.sets[i].getEnvelopeNext();
            }
            j = this.sets[i].getKernelFirst();
            while (j != Integer.MIN_VALUE) {
                this.invsets[j - this.offSet2].addToKernel(i + this.offSet1, this.aCause);
                j = this.sets[i].getKernelNext();
            }
        }
        for (i = 0; i < this.n2; ++i) {
            j = this.invsets[i].getEnvelopeFirst();
            while (j != Integer.MIN_VALUE) {
                if (j < this.offSet2 || j >= this.n + this.offSet2 || !this.sets[j - this.offSet1].envelopeContains(i + this.offSet2)) {
                    this.invsets[i].removeFromEnvelope(j, this.aCause);
                }
                j = this.invsets[i].getEnvelopeNext();
            }
            j = this.invsets[i].getKernelFirst();
            while (j != Integer.MIN_VALUE) {
                this.sets[j - this.offSet1].addToKernel(i + this.offSet2, this.aCause);
                j = this.invsets[i].getKernelNext();
            }
        }
        for (i = 0; i < this.n + this.n2; ++i) {
            this.sdm[i].unfreeze();
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.idx = idxVarInProp;
        this.toFilter = this.invsets;
        if (this.idx >= this.n) {
            this.idx -= this.n;
            this.toFilter = this.sets;
            this.idx += this.offSet2;
            this.offSet = this.offSet1;
        } else {
            this.idx += this.offSet1;
            this.offSet = this.offSet2;
        }
        this.sdm[idxVarInProp].freeze();
        this.sdm[idxVarInProp].forEach(this.elementForced, SetEventType.ADD_TO_KER);
        this.sdm[idxVarInProp].forEach(this.elementRemoved, SetEventType.REMOVE_FROM_ENVELOPE);
        this.sdm[idxVarInProp].unfreeze();
    }

    @Override
    public ESat isEntailed() {
        int j;
        int i;
        for (i = 0; i < this.n; ++i) {
            j = this.sets[i].getKernelFirst();
            while (j != Integer.MIN_VALUE) {
                if (!this.invsets[j - this.offSet2].envelopeContains(i + this.offSet1)) {
                    return ESat.FALSE;
                }
                j = this.sets[i].getKernelNext();
            }
        }
        for (i = 0; i < this.n2; ++i) {
            j = this.invsets[i].getKernelFirst();
            while (j != Integer.MIN_VALUE) {
                if (!this.sets[j - this.offSet1].envelopeContains(i + this.offSet2)) {
                    return ESat.FALSE;
                }
                j = this.invsets[i].getKernelNext();
            }
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int s1 = this.sets.length;
            SetVar[] set1 = new SetVar[s1];
            for (int i = 0; i < s1; ++i) {
                this.sets[i].duplicate(solver, identitymap);
                set1[i] = (SetVar)identitymap.get(this.sets[i]);
            }
            int s2 = this.invsets.length;
            SetVar[] set2 = new SetVar[s2];
            for (int i = 0; i < s2; ++i) {
                this.invsets[i].duplicate(solver, identitymap);
                set2[i] = (SetVar)identitymap.get(this.invsets[i]);
            }
            identitymap.put(this, new PropInverse(set1, set2, this.offSet1, this.offSet2));
        }
    }
}

