/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;

public class PropMinElement
extends Propagator<Variable> {
    private IntVar min;
    private SetVar set;
    private int offSet;
    private int[] weights;
    private final boolean notEmpty;

    public PropMinElement(SetVar setVar, IntVar min, boolean notEmpty) {
        this(setVar, (int[])null, 0, min, notEmpty);
    }

    public PropMinElement(SetVar setVar, int[] weights, int offSet, IntVar min, boolean notEmpty) {
        super(new Variable[]{setVar, min}, PropagatorPriority.BINARY, false);
        this.min = (IntVar)this.vars[1];
        this.set = (SetVar)this.vars[0];
        this.weights = weights;
        this.offSet = offSet;
        this.notEmpty = notEmpty;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == 0) {
            return SetEventType.all();
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int j = this.set.getKernelFirst();
        while (j != Integer.MIN_VALUE) {
            this.min.updateUpperBound(this.get(j), this.aCause);
            j = this.set.getKernelNext();
        }
        int minVal = Integer.MAX_VALUE;
        int lb = this.min.getLB();
        int j2 = this.set.getEnvelopeFirst();
        while (j2 != Integer.MIN_VALUE) {
            int k = this.get(j2);
            if (k < lb) {
                this.set.removeFromEnvelope(j2, this.aCause);
            } else if (minVal > k) {
                minVal = k;
            }
            j2 = this.set.getEnvelopeNext();
        }
        if (this.notEmpty || this.set.getKernelSize() > 0) {
            this.min.updateLowerBound(minVal, this.aCause);
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.set.getEnvelopeSize() == 0) {
            if (this.notEmpty) {
                return ESat.FALSE;
            }
            return ESat.TRUE;
        }
        int lb = this.min.getLB();
        int ub = this.min.getUB();
        int j = this.set.getKernelFirst();
        while (j != Integer.MIN_VALUE) {
            if (this.get(j) < lb) {
                return ESat.FALSE;
            }
            j = this.set.getKernelNext();
        }
        int minVal = Integer.MAX_VALUE;
        int j2 = this.set.getEnvelopeFirst();
        while (j2 != Integer.MIN_VALUE) {
            if (minVal > this.get(j2)) {
                minVal = this.get(j2);
            }
            j2 = this.set.getEnvelopeNext();
        }
        if (minVal > ub && (this.notEmpty || this.set.getKernelSize() > 0)) {
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    private int get(int j) {
        return this.weights == null ? j : this.weights[j - this.offSet];
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            this.set.duplicate(solver, identitymap);
            SetVar S = (SetVar)identitymap.get(this.set);
            this.min.duplicate(solver, identitymap);
            IntVar M = (IntVar)identitymap.get(this.min);
            identitymap.put(this, new PropMinElement(S, M, this.notEmpty));
        }
    }
}

