/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.tools.ArrayUtils;

public class PropNbEmpty
extends Propagator<Variable> {
    private SetVar[] sets;
    private IntVar nbEmpty;
    private int n;
    private ISet canBeEmpty;
    private ISet isEmpty;
    private IStateInt nbAlreadyEmpty;
    private IStateInt nbMaybeEmpty;

    public PropNbEmpty(SetVar[] sets, IntVar nbEmpty) {
        super(ArrayUtils.append(sets, {nbEmpty}), PropagatorPriority.UNARY, true);
        this.n = sets.length;
        this.sets = new SetVar[sets.length];
        for (int i = 0; i < sets.length; ++i) {
            this.sets[i] = (SetVar)this.vars[i];
        }
        this.nbEmpty = (IntVar)this.vars[this.n];
        IEnvironment environment = this.solver.getEnvironment();
        this.canBeEmpty = SetFactory.makeStoredSet(SetType.BIPARTITESET, this.n, this.solver);
        this.isEmpty = SetFactory.makeStoredSet(SetType.BIPARTITESET, this.n, this.solver);
        this.nbAlreadyEmpty = environment.makeInt();
        this.nbMaybeEmpty = environment.makeInt();
    }

    @Override
    public boolean advise(int idxVarInProp, int mask) {
        return super.advise(idxVarInProp, mask) && (idxVarInProp >= this.n || this.canBeEmpty.contain(idxVarInProp));
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx < this.n) {
            return SetEventType.all();
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            int nbMin = 0;
            int nbMax = 0;
            this.canBeEmpty.clear();
            this.isEmpty.clear();
            for (int i = 0; i < this.n; ++i) {
                if (this.sets[i].getKernelSize() != 0) continue;
                ++nbMax;
                if (this.sets[i].getEnvelopeSize() == 0) {
                    ++nbMin;
                    this.isEmpty.add(i);
                    continue;
                }
                this.canBeEmpty.add(i);
            }
            this.nbAlreadyEmpty.set(nbMin);
            this.nbMaybeEmpty.set(nbMax - nbMin);
        }
        this.filter();
    }

    @Override
    public void propagate(int v, int mask) throws ContradictionException {
        if (v < this.n) {
            assert (this.canBeEmpty.contain(v));
            if (this.sets[v].getKernelSize() > 0) {
                this.canBeEmpty.remove(v);
                this.nbMaybeEmpty.add(-1);
            } else if (this.sets[v].getEnvelopeSize() == 0) {
                this.isEmpty.add(v);
                this.canBeEmpty.remove(v);
                this.nbMaybeEmpty.add(-1);
                this.nbAlreadyEmpty.add(1);
            }
        }
        this.filter();
    }

    public void filter() throws ContradictionException {
        int nbMin = this.nbAlreadyEmpty.get();
        int nbMax = nbMin + this.nbMaybeEmpty.get();
        this.nbEmpty.updateLowerBound(nbMin, this.aCause);
        this.nbEmpty.updateUpperBound(nbMax, this.aCause);
        if (this.nbEmpty.isInstantiated() && nbMin < nbMax) {
            if (this.nbEmpty.getValue() == nbMax) {
                int i = this.canBeEmpty.getFirstElement();
                while (i >= 0) {
                    int j = this.sets[i].getEnvelopeFirst();
                    while (j != Integer.MIN_VALUE) {
                        this.sets[i].removeFromEnvelope(j, this.aCause);
                        j = this.sets[i].getEnvelopeNext();
                    }
                    this.canBeEmpty.remove(i);
                    this.isEmpty.add(i);
                    i = this.canBeEmpty.getNextElement();
                }
                this.setPassive();
            }
            if (this.nbEmpty.getValue() == nbMin) {
                boolean allFixed = true;
                int i = this.canBeEmpty.getFirstElement();
                while (i >= 0) {
                    if (this.sets[i].getEnvelopeSize() == 1) {
                        this.sets[i].addToKernel(this.sets[i].getEnvelopeFirst(), this.aCause);
                        this.canBeEmpty.remove(i);
                    } else {
                        allFixed = false;
                    }
                    i = this.canBeEmpty.getNextElement();
                }
                if (allFixed) {
                    this.setPassive();
                }
            }
        }
    }

    @Override
    public ESat isEntailed() {
        int nbMin = 0;
        int nbMax = 0;
        for (int i = 0; i < this.n; ++i) {
            if (this.sets[i].getKernelSize() != 0) continue;
            ++nbMax;
            if (this.sets[i].getEnvelopeSize() != 0) continue;
            ++nbMin;
        }
        if (this.nbEmpty.getLB() > nbMax || this.nbEmpty.getUB() < nbMin) {
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = this.sets.length;
            SetVar[] svars = new SetVar[size];
            for (int i = 0; i < size; ++i) {
                this.sets[i].duplicate(solver, identitymap);
                svars[i] = (SetVar)identitymap.get(this.sets[i]);
            }
            this.nbEmpty.duplicate(solver, identitymap);
            IntVar C = (IntVar)identitymap.get(this.nbEmpty);
            identitymap.put(this, new PropNbEmpty(svars, C));
        }
    }
}

