/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public class PropNotMemberIntSet
extends Propagator<IntVar> {
    IntVar iv;
    SetVar sv;

    public PropNotMemberIntSet(IntVar iv, SetVar sv) {
        super((Variable[])new IntVar[]{iv}, PropagatorPriority.UNARY, true);
        this.iv = iv;
        this.sv = sv;
    }

    @Override
    public int getPropagationConditions(int vidx) {
        return IntEventType.instantiation();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.iv.isInstantiated()) {
            this.sv.removeFromEnvelope(this.iv.getValue(), this.aCause);
            this.setPassive();
        }
    }

    @Override
    public void propagate(int vidx, int evtmask) throws ContradictionException {
        assert (this.iv.isInstantiated());
        this.sv.removeFromEnvelope(this.iv.getValue(), this.aCause);
        this.setPassive();
    }

    @Override
    public ESat isEntailed() {
        if (this.iv.isInstantiated()) {
            int v = this.iv.getValue();
            if (this.sv.envelopeContains(v)) {
                if (this.sv.kernelContains(v)) {
                    return ESat.FALSE;
                }
                return ESat.UNDEFINED;
            }
            return ESat.TRUE;
        }
        int v = this.iv.getLB();
        while (v <= this.iv.getUB()) {
            if (!this.sv.kernelContains(v)) {
                return ESat.UNDEFINED;
            }
            v = this.iv.nextValue(v);
        }
        return ESat.FALSE;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            this.sv.duplicate(solver, identitymap);
            SetVar S = (SetVar)identitymap.get(this.sv);
            this.iv.duplicate(solver, identitymap);
            IntVar I = (IntVar)identitymap.get(this.iv);
            identitymap.put(this, new PropNotMemberIntSet(I, S));
        }
    }
}

