/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.procedure.IntProcedure;

public class PropNotMemberSetInt
extends Propagator<SetVar> {
    IntVar iv;
    SetVar sv;
    ISetDeltaMonitor sdm;
    IntProcedure elemRem;

    public PropNotMemberSetInt(IntVar intVar, SetVar setVar) {
        super((Variable[])new SetVar[]{setVar}, PropagatorPriority.UNARY, true);
        this.iv = intVar;
        this.sv = setVar;
        this.sdm = this.sv.monitorDelta(this.aCause);
        this.elemRem = i -> this.iv.removeValue(i, this.aCause);
    }

    @Override
    public int getPropagationConditions(int vidx) {
        return SetEventType.ADD_TO_KER.getMask();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int v = this.sv.getKernelFirst();
        while (v != Integer.MIN_VALUE) {
            this.iv.removeValue(v, this.aCause);
            v = this.sv.getKernelNext();
        }
        if (this.sv.isInstantiated()) {
            this.setPassive();
        }
        this.sdm.unfreeze();
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.sdm.freeze();
        this.sdm.forEach(this.elemRem, SetEventType.ADD_TO_KER);
        this.sdm.unfreeze();
        if (this.sv.isInstantiated()) {
            this.setPassive();
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.iv.isInstantiated()) {
            int v = this.iv.getValue();
            if (this.sv.envelopeContains(v)) {
                if (this.sv.kernelContains(v)) {
                    return ESat.FALSE;
                }
                return ESat.UNDEFINED;
            }
            return ESat.TRUE;
        }
        int v = this.iv.getLB();
        while (v <= this.iv.getUB()) {
            if (!this.sv.kernelContains(v)) {
                return ESat.UNDEFINED;
            }
            v = this.iv.nextValue(v);
        }
        return ESat.FALSE;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            this.sv.duplicate(solver, identitymap);
            SetVar S = (SetVar)identitymap.get(this.sv);
            this.iv.duplicate(solver, identitymap);
            IntVar I = (IntVar)identitymap.get(this.iv);
            identitymap.put(this, new PropNotMemberSetInt(I, S));
        }
    }
}

