/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.procedure.IntProcedure;

public class PropOffSet
extends Propagator<SetVar> {
    private int offSet;
    private int tmp;
    private SetVar tmpSet;
    private IntProcedure forced;
    private IntProcedure removed;
    private ISetDeltaMonitor[] sdm;

    public PropOffSet(SetVar set1, SetVar set2, int offSet) {
        super((Variable[])new SetVar[]{set1, set2}, PropagatorPriority.UNARY, true);
        this.offSet = offSet;
        this.sdm = new ISetDeltaMonitor[2];
        this.sdm[0] = ((SetVar[])this.vars)[0].monitorDelta(this);
        this.sdm[1] = ((SetVar[])this.vars)[1].monitorDelta(this);
        this.forced = i -> this.tmpSet.addToKernel(i + this.tmp, this.aCause);
        this.removed = i -> this.tmpSet.removeFromEnvelope(i + this.tmp, this.aCause);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int j = ((SetVar[])this.vars)[0].getKernelFirst();
        while (j != Integer.MIN_VALUE) {
            ((SetVar[])this.vars)[1].addToKernel(j + this.offSet, this.aCause);
            j = ((SetVar[])this.vars)[0].getKernelNext();
        }
        j = ((SetVar[])this.vars)[1].getKernelFirst();
        while (j != Integer.MIN_VALUE) {
            ((SetVar[])this.vars)[0].addToKernel(j - this.offSet, this.aCause);
            j = ((SetVar[])this.vars)[1].getKernelNext();
        }
        j = ((SetVar[])this.vars)[0].getEnvelopeFirst();
        while (j != Integer.MIN_VALUE) {
            if (!((SetVar[])this.vars)[1].envelopeContains(j + this.offSet)) {
                ((SetVar[])this.vars)[0].removeFromEnvelope(j, this.aCause);
            }
            j = ((SetVar[])this.vars)[0].getEnvelopeNext();
        }
        j = ((SetVar[])this.vars)[1].getEnvelopeFirst();
        while (j != Integer.MIN_VALUE) {
            if (!((SetVar[])this.vars)[0].envelopeContains(j - this.offSet)) {
                ((SetVar[])this.vars)[1].removeFromEnvelope(j, this.aCause);
            }
            j = ((SetVar[])this.vars)[1].getEnvelopeNext();
        }
        this.sdm[0].unfreeze();
        this.sdm[1].unfreeze();
    }

    @Override
    public void propagate(int v, int mask) throws ContradictionException {
        this.sdm[v].freeze();
        if (v == 0) {
            this.tmp = this.offSet;
            this.tmpSet = ((SetVar[])this.vars)[1];
        } else {
            this.tmp = -this.offSet;
            this.tmpSet = ((SetVar[])this.vars)[0];
        }
        this.sdm[v].forEach(this.forced, SetEventType.ADD_TO_KER);
        this.sdm[v].forEach(this.removed, SetEventType.REMOVE_FROM_ENVELOPE);
        this.sdm[v].unfreeze();
    }

    @Override
    public ESat isEntailed() {
        int j = ((SetVar[])this.vars)[0].getKernelFirst();
        while (j != Integer.MIN_VALUE) {
            if (!((SetVar[])this.vars)[1].envelopeContains(j + this.offSet)) {
                return ESat.FALSE;
            }
            j = ((SetVar[])this.vars)[0].getKernelNext();
        }
        j = ((SetVar[])this.vars)[1].getKernelFirst();
        while (j != Integer.MIN_VALUE) {
            if (!((SetVar[])this.vars)[0].envelopeContains(j - this.offSet)) {
                return ESat.FALSE;
            }
            j = ((SetVar[])this.vars)[1].getKernelNext();
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            ((SetVar[])this.vars)[0].duplicate(solver, identitymap);
            SetVar s1 = (SetVar)identitymap.get(((SetVar[])this.vars)[0]);
            ((SetVar[])this.vars)[1].duplicate(solver, identitymap);
            SetVar s2 = (SetVar)identitymap.get(((SetVar[])this.vars)[1]);
            identitymap.put(this, new PropOffSet(s1, s2, this.offSet));
        }
    }
}

