/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropSetIntValuesUnion
extends Propagator<Variable> {
    protected IntVar[] X;
    protected SetVar values;

    public PropSetIntValuesUnion(IntVar[] X, SetVar values) {
        super(ArrayUtils.append(X, {values}));
        this.X = X;
        this.values = values;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int v = this.values.getEnvelopeFirst();
        while (v != Integer.MIN_VALUE) {
            int support = -1;
            for (int i = 0; i < this.X.length; ++i) {
                if (!this.X[i].contains(v)) continue;
                if (support == -1) {
                    support = i;
                    continue;
                }
                support = -2;
                break;
            }
            if (support == -1) {
                this.values.removeFromEnvelope(v, this.aCause);
            } else if (support != -2 && this.values.kernelContains(v)) {
                this.X[support].instantiateTo(v, this.aCause);
            }
            v = this.values.getEnvelopeNext();
        }
        for (int i = 0; i < this.X.length; ++i) {
            int v2 = this.X[i].getLB();
            while (v2 <= this.X[i].getUB()) {
                if (!this.values.envelopeContains(v2)) {
                    this.X[i].removeValue(v2, this.aCause);
                }
                if (this.X[i].isInstantiated()) {
                    this.values.addToKernel(v2, this.aCause);
                }
                v2 = this.X[i].nextValue(v2);
            }
        }
    }

    @Override
    public ESat isEntailed() {
        int v = this.values.getKernelFirst();
        while (v != Integer.MIN_VALUE) {
            int support = -1;
            for (int i = 0; i < this.X.length; ++i) {
                if (!this.X[i].contains(v)) continue;
                if (support == -1) {
                    support = i;
                    continue;
                }
                support = -2;
                break;
            }
            if (support == -1) {
                return ESat.FALSE;
            }
            v = this.values.getKernelNext();
        }
        for (IntVar x : this.X) {
            if (!x.isInstantiated() || this.values.envelopeContains(x.getValue())) continue;
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

