/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.procedure.IntProcedure;

public class PropSubsetEq
extends Propagator<SetVar> {
    private ISetDeltaMonitor[] sdm = new ISetDeltaMonitor[2];
    private IntProcedure elementForced;
    private IntProcedure elementRemoved;

    public PropSubsetEq(SetVar X, SetVar Y) {
        super((Variable[])new SetVar[]{X, Y}, PropagatorPriority.LINEAR, true);
        for (int i = 0; i < 2; ++i) {
            this.sdm[i] = ((SetVar[])this.vars)[i].monitorDelta(this);
        }
        this.elementForced = element -> ((SetVar[])this.vars)[1].addToKernel(element, this.aCause);
        this.elementRemoved = element -> ((SetVar[])this.vars)[0].removeFromEnvelope(element, this.aCause);
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == 0) {
            return SetEventType.ADD_TO_KER.getMask();
        }
        return SetEventType.REMOVE_FROM_ENVELOPE.getMask();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int j = ((SetVar[])this.vars)[0].getKernelFirst();
        while (j != Integer.MIN_VALUE) {
            ((SetVar[])this.vars)[1].addToKernel(j, this.aCause);
            j = ((SetVar[])this.vars)[0].getKernelNext();
        }
        j = ((SetVar[])this.vars)[0].getEnvelopeFirst();
        while (j != Integer.MIN_VALUE) {
            if (!((SetVar[])this.vars)[1].envelopeContains(j)) {
                ((SetVar[])this.vars)[0].removeFromEnvelope(j, this.aCause);
            }
            j = ((SetVar[])this.vars)[0].getEnvelopeNext();
        }
        this.sdm[0].unfreeze();
        this.sdm[1].unfreeze();
    }

    @Override
    public void propagate(int i, int mask) throws ContradictionException {
        this.sdm[i].freeze();
        if (i == 0) {
            this.sdm[i].forEach(this.elementForced, SetEventType.ADD_TO_KER);
        } else {
            this.sdm[i].forEach(this.elementRemoved, SetEventType.REMOVE_FROM_ENVELOPE);
        }
        this.sdm[i].unfreeze();
    }

    @Override
    public ESat isEntailed() {
        int j = ((SetVar[])this.vars)[0].getKernelFirst();
        while (j != Integer.MIN_VALUE) {
            if (!((SetVar[])this.vars)[1].envelopeContains(j)) {
                return ESat.FALSE;
            }
            j = ((SetVar[])this.vars)[0].getKernelNext();
        }
        j = ((SetVar[])this.vars)[0].getEnvelopeFirst();
        while (j != Integer.MIN_VALUE) {
            if (!((SetVar[])this.vars)[1].kernelContains(j)) {
                return ESat.UNDEFINED;
            }
            j = ((SetVar[])this.vars)[0].getEnvelopeNext();
        }
        return ESat.TRUE;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            ((SetVar[])this.vars)[0].duplicate(solver, identitymap);
            SetVar s1 = (SetVar)identitymap.get(((SetVar[])this.vars)[0]);
            ((SetVar[])this.vars)[1].duplicate(solver, identitymap);
            SetVar s2 = (SetVar)identitymap.get(((SetVar[])this.vars)[1]);
            identitymap.put(this, new PropSubsetEq(s1, s2));
        }
    }
}

