/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;

public class PropSumOfElements
extends Propagator<Variable> {
    private IntVar sum;
    private SetVar set;
    private int offSet;
    private int[] weights;
    private final boolean notEmpty;

    public PropSumOfElements(SetVar indexes, int[] weights, int offset, IntVar sum, boolean notEmpty) {
        super(new Variable[]{indexes, sum}, PropagatorPriority.BINARY, true);
        this.sum = (IntVar)this.vars[1];
        this.set = (SetVar)this.vars[0];
        this.weights = weights;
        this.offSet = offset;
        this.notEmpty = notEmpty;
    }

    public PropSumOfElements(SetVar setVar, IntVar sum, boolean notEmpty) {
        this(setVar, (int[])null, 0, sum, notEmpty);
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == 0) {
            return SetEventType.all();
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.weights != null) {
            int j = this.set.getEnvelopeFirst();
            while (j != Integer.MIN_VALUE) {
                if (j < this.offSet || j >= this.weights.length + this.offSet) {
                    this.set.removeFromEnvelope(j, this.aCause);
                }
                j = this.set.getEnvelopeNext();
            }
        }
        this.propagate(0, 0);
    }

    @Override
    public void propagate(int i, int mask) throws ContradictionException {
        int sK = 0;
        int sE = 0;
        int j = this.set.getKernelFirst();
        while (j != Integer.MIN_VALUE) {
            sK += this.get(j);
            j = this.set.getKernelNext();
        }
        j = this.set.getEnvelopeFirst();
        while (j != Integer.MIN_VALUE) {
            sE += this.get(j);
            j = this.set.getEnvelopeNext();
        }
        if (this.notEmpty || this.set.getKernelSize() > 0) {
            this.sum.updateLowerBound(sK, this.aCause);
            this.sum.updateUpperBound(sE, this.aCause);
        }
        boolean again = false;
        int lb = this.sum.getLB();
        int ub = this.sum.getUB();
        int j2 = this.set.getEnvelopeFirst();
        while (j2 != Integer.MIN_VALUE) {
            if (!this.set.kernelContains(j2)) {
                if (sE - this.get(j2) < lb) {
                    if (this.set.addToKernel(j2, this.aCause)) {
                        again = true;
                    }
                } else if (sK + this.get(j2) > ub && this.set.removeFromEnvelope(j2, this.aCause)) {
                    again = true;
                }
            }
            j2 = this.set.getEnvelopeNext();
        }
        if (again) {
            this.propagate(0, 0);
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.set.getEnvelopeSize() == 0) {
            if (this.notEmpty) {
                return ESat.FALSE;
            }
            return ESat.TRUE;
        }
        int sK = 0;
        int sE = 0;
        int j = this.set.getKernelFirst();
        while (j != Integer.MIN_VALUE) {
            sK += this.get(j);
            j = this.set.getKernelNext();
        }
        j = this.set.getEnvelopeFirst();
        while (j != Integer.MIN_VALUE) {
            sE += this.get(j);
            j = this.set.getEnvelopeNext();
        }
        int lb = this.sum.getLB();
        int ub = this.sum.getUB();
        if (!(lb <= sE && ub >= sK || !this.notEmpty && this.set.getKernelSize() <= 0)) {
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    private int get(int j) {
        return this.weights == null ? j : this.weights[j - this.offSet];
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            this.set.duplicate(solver, identitymap);
            SetVar se = (SetVar)identitymap.get(this.set);
            this.sum.duplicate(solver, identitymap);
            IntVar su = (IntVar)identitymap.get(this.sum);
            identitymap.put(this, new PropSumOfElements(se, this.weights == null ? null : (int[])this.weights.clone(), this.offSet, su, this.notEmpty));
        }
    }
}

