/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.procedure.IntProcedure;

public class PropSymmetric
extends Propagator<SetVar> {
    private int n;
    private int currentSet;
    private int offSet;
    private ISetDeltaMonitor[] sdm;
    private IntProcedure elementForced;
    private IntProcedure elementRemoved;

    public PropSymmetric(SetVar[] sets, int offSet) {
        super((Variable[])sets, PropagatorPriority.LINEAR, true);
        this.n = sets.length;
        this.offSet = offSet;
        this.sdm = new ISetDeltaMonitor[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.sdm[i] = ((SetVar[])this.vars)[i].monitorDelta(this);
        }
        this.elementForced = element -> ((SetVar[])this.vars)[element - offSet].addToKernel(this.currentSet + offSet, this.aCause);
        this.elementRemoved = element -> ((SetVar[])this.vars)[element - offSet].removeFromEnvelope(this.currentSet + offSet, this.aCause);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        for (i = 0; i < this.n; ++i) {
            int j = ((SetVar[])this.vars)[i].getEnvelopeFirst();
            while (j != Integer.MIN_VALUE) {
                if (j < this.offSet || j >= this.n + this.offSet || !((SetVar[])this.vars)[j - this.offSet].envelopeContains(i + this.offSet)) {
                    ((SetVar[])this.vars)[i].removeFromEnvelope(j, this.aCause);
                }
                j = ((SetVar[])this.vars)[i].getEnvelopeNext();
            }
            j = ((SetVar[])this.vars)[i].getKernelFirst();
            while (j != Integer.MIN_VALUE) {
                ((SetVar[])this.vars)[j - this.offSet].addToKernel(i + this.offSet, this.aCause);
                j = ((SetVar[])this.vars)[i].getKernelNext();
            }
        }
        for (i = 0; i < this.n; ++i) {
            this.sdm[i].unfreeze();
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.currentSet = idxVarInProp;
        this.sdm[this.currentSet].freeze();
        this.sdm[this.currentSet].forEach(this.elementForced, SetEventType.ADD_TO_KER);
        this.sdm[this.currentSet].forEach(this.elementRemoved, SetEventType.REMOVE_FROM_ENVELOPE);
        this.sdm[this.currentSet].unfreeze();
    }

    @Override
    public ESat isEntailed() {
        for (int i = 0; i < this.n; ++i) {
            int j = ((SetVar[])this.vars)[i].getKernelFirst();
            while (j != Integer.MIN_VALUE) {
                if (!((SetVar[])this.vars)[j - this.offSet].envelopeContains(i + this.offSet)) {
                    return ESat.FALSE;
                }
                j = ((SetVar[])this.vars)[i].getKernelNext();
            }
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int n = ((SetVar[])this.vars).length;
            SetVar[] svars = new SetVar[n];
            for (int i = 0; i < n; ++i) {
                ((SetVar[])this.vars)[i].duplicate(solver, identitymap);
                svars[i] = (SetVar)identitymap.get(((SetVar[])this.vars)[i]);
            }
            identitymap.put(this, new PropSymmetric(svars, this.offSet));
        }
    }
}

