/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.tools.ArrayUtils;

public class PropUnion
extends Propagator<SetVar> {
    private int k;
    private ISetDeltaMonitor[] sdm;
    private IntProcedure unionForced;
    private IntProcedure unionRemoved;
    private IntProcedure setForced;
    private IntProcedure setRemoved;

    public PropUnion(SetVar[] sets, SetVar union) {
        super((Variable[])ArrayUtils.append(sets, {union}), PropagatorPriority.LINEAR, true);
        this.k = sets.length;
        this.sdm = new ISetDeltaMonitor[this.k + 1];
        for (int i = 0; i <= this.k; ++i) {
            this.sdm[i] = ((SetVar[])this.vars)[i].monitorDelta(this);
        }
        this.unionForced = element -> {
            int mate = -1;
            for (int i = 0; i < this.k && mate != -2; ++i) {
                if (!((SetVar[])this.vars)[i].envelopeContains(element)) continue;
                mate = mate == -1 ? i : -2;
            }
            if (mate == -1) {
                this.contradiction(((SetVar[])this.vars)[this.k], "");
            } else if (mate != -2) {
                ((SetVar[])this.vars)[mate].addToKernel(element, this.aCause);
            }
        };
        this.unionRemoved = element -> {
            for (int i = 0; i < this.k; ++i) {
                ((SetVar[])this.vars)[i].removeFromEnvelope(element, this.aCause);
            }
        };
        this.setForced = element -> ((SetVar[])this.vars)[this.k].addToKernel(element, this.aCause);
        this.setRemoved = element -> {
            if (((SetVar[])this.vars)[this.k].envelopeContains(element)) {
                int mate = -1;
                for (int i = 0; i < this.k && mate != -2; ++i) {
                    if (!((SetVar[])this.vars)[i].envelopeContains(element)) continue;
                    mate = mate == -1 ? i : -2;
                }
                if (mate == -1) {
                    ((SetVar[])this.vars)[this.k].removeFromEnvelope(element, this.aCause);
                } else if (mate != -2 && ((SetVar[])this.vars)[this.k].kernelContains(element)) {
                    ((SetVar[])this.vars)[mate].addToKernel(element, this.aCause);
                }
            }
        };
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            int i;
            SetVar union = ((SetVar[])this.vars)[this.k];
            for (i = 0; i < this.k; ++i) {
                int j = ((SetVar[])this.vars)[i].getKernelFirst();
                while (j != Integer.MIN_VALUE) {
                    union.addToKernel(j, this.aCause);
                    j = ((SetVar[])this.vars)[i].getKernelNext();
                }
                j = ((SetVar[])this.vars)[i].getEnvelopeFirst();
                while (j != Integer.MIN_VALUE) {
                    if (!union.envelopeContains(j)) {
                        ((SetVar[])this.vars)[i].removeFromEnvelope(j, this.aCause);
                    }
                    j = ((SetVar[])this.vars)[i].getEnvelopeNext();
                }
            }
            int j = union.getEnvelopeFirst();
            while (j != Integer.MIN_VALUE) {
                int i2;
                int mate;
                if (union.kernelContains(j)) {
                    mate = -1;
                    for (i2 = 0; i2 < this.k && mate != -2; ++i2) {
                        if (!((SetVar[])this.vars)[i2].envelopeContains(j)) continue;
                        mate = mate == -1 ? i2 : -2;
                    }
                    if (mate == -1) {
                        this.contradiction(((SetVar[])this.vars)[this.k], "");
                    } else if (mate != -2) {
                        ((SetVar[])this.vars)[mate].addToKernel(j, this.aCause);
                    }
                } else {
                    mate = -1;
                    for (i2 = 0; i2 < this.k; ++i2) {
                        if (!((SetVar[])this.vars)[i2].envelopeContains(j)) continue;
                        mate = i2;
                        break;
                    }
                    if (mate == -1) {
                        union.removeFromEnvelope(j, this.aCause);
                    }
                }
                j = union.getEnvelopeNext();
            }
            for (i = 0; i <= this.k; ++i) {
                this.sdm[i].unfreeze();
            }
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.sdm[idxVarInProp].freeze();
        if (idxVarInProp < this.k) {
            this.sdm[idxVarInProp].forEach(this.setForced, SetEventType.ADD_TO_KER);
            this.sdm[idxVarInProp].forEach(this.setRemoved, SetEventType.REMOVE_FROM_ENVELOPE);
        } else {
            this.sdm[idxVarInProp].forEach(this.unionForced, SetEventType.ADD_TO_KER);
            this.sdm[idxVarInProp].forEach(this.unionRemoved, SetEventType.REMOVE_FROM_ENVELOPE);
        }
        this.sdm[idxVarInProp].unfreeze();
    }

    @Override
    public ESat isEntailed() {
        for (int i = 0; i < this.k; ++i) {
            int j = ((SetVar[])this.vars)[i].getKernelFirst();
            while (j != Integer.MIN_VALUE) {
                if (!((SetVar[])this.vars)[this.k].envelopeContains(j)) {
                    return ESat.FALSE;
                }
                j = ((SetVar[])this.vars)[i].getKernelNext();
            }
        }
        int j = ((SetVar[])this.vars)[this.k].getKernelFirst();
        while (j != Integer.MIN_VALUE) {
            int mate = -1;
            for (int i = 0; i < this.k; ++i) {
                if (!((SetVar[])this.vars)[i].envelopeContains(j)) continue;
                mate = i;
                break;
            }
            if (mate == -1) {
                return ESat.FALSE;
            }
            j = ((SetVar[])this.vars)[this.k].getKernelNext();
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((SetVar[])this.vars).length - 1;
            SetVar[] svars = new SetVar[size];
            for (int i = 0; i < size; ++i) {
                ((SetVar[])this.vars)[i].duplicate(solver, identitymap);
                svars[i] = (SetVar)identitymap.get(((SetVar[])this.vars)[i]);
            }
            ((SetVar[])this.vars)[size].duplicate(solver, identitymap);
            SetVar svar = (SetVar)identitymap.get(((SetVar[])this.vars)[size]);
            identitymap.put(this, new PropUnion(svars, svar));
        }
    }
}

