/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.set.PropAllDiff;
import org.chocosolver.solver.constraints.set.PropAllDisjoint;
import org.chocosolver.solver.constraints.set.PropAllEqual;
import org.chocosolver.solver.constraints.set.PropAtMost1Empty;
import org.chocosolver.solver.constraints.set.PropBoolChannel;
import org.chocosolver.solver.constraints.set.PropCardinality;
import org.chocosolver.solver.constraints.set.PropElement;
import org.chocosolver.solver.constraints.set.PropIntBoundedMemberSet;
import org.chocosolver.solver.constraints.set.PropIntChannel;
import org.chocosolver.solver.constraints.set.PropIntEnumMemberSet;
import org.chocosolver.solver.constraints.set.PropIntersection;
import org.chocosolver.solver.constraints.set.PropInverse;
import org.chocosolver.solver.constraints.set.PropMaxElement;
import org.chocosolver.solver.constraints.set.PropMinElement;
import org.chocosolver.solver.constraints.set.PropNbEmpty;
import org.chocosolver.solver.constraints.set.PropNotEmpty;
import org.chocosolver.solver.constraints.set.PropNotMemberIntSet;
import org.chocosolver.solver.constraints.set.PropNotMemberSetInt;
import org.chocosolver.solver.constraints.set.PropOffSet;
import org.chocosolver.solver.constraints.set.PropSetIntValuesUnion;
import org.chocosolver.solver.constraints.set.PropSubsetEq;
import org.chocosolver.solver.constraints.set.PropSumOfElements;
import org.chocosolver.solver.constraints.set.PropSymmetric;
import org.chocosolver.solver.constraints.set.PropUnion;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.VF;
import org.chocosolver.solver.variables.VariableFactory;
import org.chocosolver.util.tools.ArrayUtils;

public class SetConstraintsFactory {
    SetConstraintsFactory() {
    }

    public static Constraint union(SetVar[] SETS, SetVar UNION) {
        return new Constraint("SetUnion", new PropUnion(SETS, UNION), new PropUnion(SETS, UNION));
    }

    public static Constraint intersection(SetVar[] SETS, SetVar INTERSECTION) {
        return new Constraint("SetIntersection", new PropIntersection(SETS, INTERSECTION), new PropIntersection(SETS, INTERSECTION));
    }

    public static Constraint subsetEq(SetVar[] SETS) {
        Propagator[] props = new Propagator[SETS.length - 1];
        for (int i = 0; i < SETS.length - 1; ++i) {
            props[i] = new PropSubsetEq(SETS[i], SETS[i + 1]);
        }
        return new Constraint("SetSubsetEq", props);
    }

    public static Constraint cardinality(SetVar SET, IntVar CARD) {
        return new Constraint("SetCard", new PropCardinality(SET, CARD));
    }

    public static Constraint nbEmpty(SetVar[] SETS, IntVar NB_EMPTY_SETS) {
        return new Constraint("SetNbEmpty", new PropNbEmpty(SETS, NB_EMPTY_SETS));
    }

    public static Constraint offSet(SetVar SET_1, SetVar SET_2, int OFFSET) {
        return new Constraint("SetOffset", new PropOffSet(SET_1, SET_2, OFFSET));
    }

    public static Constraint notEmpty(SetVar SET) {
        return new Constraint("SetNotEmpty", new PropNotEmpty(SET));
    }

    public static Constraint sum(SetVar SET, IntVar SUM, boolean NOT_EMPTY) {
        return SetConstraintsFactory.sum(SET, null, 0, SUM, NOT_EMPTY);
    }

    public static Constraint sum(SetVar INDEXES, int[] WEIGHTS, int OFFSET, IntVar SUM, boolean NOT_EMPTY) {
        if (NOT_EMPTY) {
            return new Constraint("SetSum_NotEmpty", new PropNotEmpty(INDEXES), new PropSumOfElements(INDEXES, WEIGHTS, OFFSET, SUM, true));
        }
        return new Constraint("SetSum", new PropSumOfElements(INDEXES, WEIGHTS, OFFSET, SUM, false));
    }

    public static Constraint max(SetVar SET, IntVar MAX_ELEMENT_VALUE, boolean NOT_EMPTY) {
        return SetConstraintsFactory.max(SET, null, 0, MAX_ELEMENT_VALUE, NOT_EMPTY);
    }

    public static Constraint max(SetVar INDEXES, int[] WEIGHTS, int OFFSET, IntVar MAX_ELEMENT_VALUE, boolean NOT_EMPTY) {
        if (NOT_EMPTY) {
            return new Constraint("SetMax_NotEmpty", new PropNotEmpty(INDEXES), new PropMaxElement(INDEXES, WEIGHTS, OFFSET, MAX_ELEMENT_VALUE, true));
        }
        return new Constraint("SetMax", new PropMaxElement(INDEXES, WEIGHTS, OFFSET, MAX_ELEMENT_VALUE, false));
    }

    public static Constraint min(SetVar SET, IntVar MIN_ELEMENT_VALUE, boolean NOT_EMPTY) {
        return SetConstraintsFactory.min(SET, null, 0, MIN_ELEMENT_VALUE, NOT_EMPTY);
    }

    public static Constraint min(SetVar INDEXES, int[] WEIGHTS, int OFFSET, IntVar MIN_ELEMENT_VALUE, boolean NOT_EMPTY) {
        if (NOT_EMPTY) {
            return new Constraint("SetMin_NotEmpty", new PropNotEmpty(INDEXES), new PropMinElement(INDEXES, WEIGHTS, OFFSET, MIN_ELEMENT_VALUE, true));
        }
        return new Constraint("SetMin", new PropMinElement(INDEXES, WEIGHTS, OFFSET, MIN_ELEMENT_VALUE, false));
    }

    public static Constraint bool_channel(BoolVar[] BOOLEANS, SetVar SET, int OFFSET) {
        return new Constraint("SetBoolChanneling", new PropBoolChannel(SET, BOOLEANS, OFFSET));
    }

    public static Constraint int_channel(SetVar[] SETS, IntVar[] INTEGERS, int OFFSET_1, int OFFSET_2) {
        return new Constraint("SetIntChanneling", new PropIntChannel(SETS, INTEGERS, OFFSET_1, OFFSET_2), new PropIntChannel(SETS, INTEGERS, OFFSET_1, OFFSET_2), new PropAllDisjoint(SETS));
    }

    public static Constraint int_values_union(IntVar[] VARS, SetVar VALUES) {
        return new Constraint("SetIntValuesUnion", new PropSetIntValuesUnion(VARS, VALUES), new PropSetIntValuesUnion(VARS, VALUES));
    }

    public static Constraint disjoint(SetVar SET_1, SetVar SET_2) {
        return SetConstraintsFactory.all_disjoint(new SetVar[]{SET_1, SET_2});
    }

    public static Constraint all_disjoint(SetVar[] SETS) {
        return new Constraint("SetAllDisjoint", new PropAllDisjoint(SETS));
    }

    public static Constraint all_different(SetVar[] SETS) {
        return new Constraint("SetAllDifferent", new PropAllDiff(SETS), new PropAllDiff(SETS), new PropAtMost1Empty(SETS));
    }

    public static Constraint all_equal(SetVar[] SETS) {
        return new Constraint("SetAllEqual", new PropAllEqual(SETS));
    }

    public static Constraint partition(SetVar[] SETS, SetVar UNIVERSE) {
        return new Constraint("SetPartition", ArrayUtils.append(SetConstraintsFactory.all_disjoint(SETS).getPropagators(), {new PropUnion(SETS, UNIVERSE), new PropUnion(SETS, UNIVERSE)}));
    }

    public static Constraint inverse_set(SetVar[] SETS, SetVar[] INVERSE_SETS, int OFFSET_1, int OFFSET_2) {
        return new Constraint("SetInverse", new PropInverse(SETS, INVERSE_SETS, OFFSET_1, OFFSET_2));
    }

    public static Constraint symmetric(SetVar[] SETS, int OFFSET) {
        return new Constraint("SetSymmetric", new PropSymmetric(SETS, OFFSET));
    }

    public static Constraint element(IntVar INDEX, SetVar[] SETS, int OFFSET, SetVar SET) {
        return new Constraint("SetElement", new PropElement(INDEX, SETS, OFFSET, SET), new PropElement(INDEX, SETS, OFFSET, SET));
    }

    public static Constraint member(SetVar[] SETS, SetVar SET) {
        IntVar index = VariableFactory.enumerated("idx_tmp", 0, SETS.length - 1, SET.getSolver());
        return SetConstraintsFactory.element(index, SETS, 0, SET);
    }

    public static Constraint member(final IntVar INTEGER, final SetVar SET) {
        return new Constraint("SetMember", new Propagator[]{INTEGER.hasEnumeratedDomain() ? new PropIntEnumMemberSet(SET, INTEGER) : new PropIntBoundedMemberSet(SET, INTEGER)}){

            @Override
            public Constraint makeOpposite() {
                return SetConstraintsFactory.not_member(INTEGER, SET);
            }
        };
    }

    public static Constraint not_member(final IntVar INTEGER, final SetVar SET) {
        IntVar integer = INTEGER;
        if (!INTEGER.hasEnumeratedDomain()) {
            Solver s = INTEGER.getSolver();
            integer = VF.enumerated("enumViewOf(" + INTEGER.getName() + ")", INTEGER.getLB(), INTEGER.getUB(), s);
            s.post(ICF.arithm(integer, "=", INTEGER));
        }
        return new Constraint("SetNotMember", new Propagator[]{new PropNotMemberIntSet(integer, SET), new PropNotMemberSetInt(integer, SET)}){

            @Override
            public Constraint makeOpposite() {
                return SetConstraintsFactory.member(INTEGER, SET);
            }
        };
    }
}

