/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.ternary;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Operator;
import org.chocosolver.solver.constraints.ternary.PropDistanceXYZ;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.tools.ArrayUtils;

public class DistanceXYZ
extends Constraint {
    final IntVar X;
    final IntVar Y;
    final IntVar Z;
    final Operator OP;

    public DistanceXYZ(IntVar x, IntVar y, Operator op, IntVar z) {
        super("DistanceXYZ " + op.name(), new PropDistanceXYZ(ArrayUtils.toArray(x, y, z), op));
        if (op != Operator.EQ && op != Operator.GT && op != Operator.LT) {
            throw new SolverException("Unexpected operator for distance");
        }
        this.X = x;
        this.Y = y;
        this.Z = z;
        this.OP = op;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            this.X.duplicate(solver, identitymap);
            IntVar X = (IntVar)identitymap.get(this.X);
            this.Y.duplicate(solver, identitymap);
            IntVar Y = (IntVar)identitymap.get(this.Y);
            this.Z.duplicate(solver, identitymap);
            IntVar Z = (IntVar)identitymap.get(this.Z);
            DistanceXYZ clone = new DistanceXYZ(X, Y, this.OP, Z);
            identitymap.put(this.propagators[0], clone.getPropagator(0));
            identitymap.put(this, clone);
        }
    }
}

