/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.ternary;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.VariableFactory;
import org.chocosolver.util.ESat;

public class PropDivXYZ
extends Propagator<IntVar> {
    final IntVar X;
    final IntVar Y;
    final IntVar Z;
    final IntVar absX;
    final IntVar absY;
    final IntVar absZ;

    public PropDivXYZ(IntVar x, IntVar y, IntVar z) {
        this(x, y, z, VariableFactory.abs(x), VariableFactory.abs(y), VariableFactory.abs(z));
    }

    private PropDivXYZ(IntVar x, IntVar y, IntVar z, IntVar ax, IntVar ay, IntVar az) {
        super((Variable[])new IntVar[]{x, y, z}, PropagatorPriority.TERNARY, false);
        this.X = x;
        this.Y = y;
        this.Z = z;
        this.absX = ax;
        this.absY = ay;
        this.absZ = az;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        boolean hasChanged;
        do {
            int mask = 0;
            mask += this.X.isInstantiated() ? 1 : 0;
            mask += this.Y.isInstantiated() ? 2 : 0;
            mask += this.Z.isInstantiated() ? 4 : 0;
            hasChanged = this.Y.removeValue(0, this.aCause);
            if (this.outInterval(this.Y, 0, 0)) {
                return;
            }
            switch (mask) {
                case 0: {
                    hasChanged |= this.updateAbsX();
                    hasChanged |= this.updateAbsY();
                    hasChanged |= this.updateAbsZ();
                    break;
                }
                case 1: {
                    hasChanged |= this.updateAbsY();
                    hasChanged |= this.updateAbsZ();
                    if (!this.X.isInstantiatedTo(0)) break;
                    hasChanged |= this.Z.instantiateTo(0, this.aCause);
                    break;
                }
                case 2: {
                    hasChanged |= this.updateAbsX();
                    hasChanged |= this.updateAbsZ();
                    break;
                }
                case 3: {
                    int vx = this.X.getValue();
                    int vy = this.Y.getValue();
                    hasChanged |= this.updateAbsX();
                    hasChanged |= this.updateAbsY();
                    int vz = vx / vy;
                    if (vy == 0 || !this.inInterval(this.Z, vz, vz)) break;
                    return;
                }
                case 4: {
                    hasChanged |= this.updateAbsX();
                    hasChanged |= this.updateAbsY();
                    if (!this.Z.isInstantiatedTo(0) || this.X.contains(0)) break;
                    hasChanged |= this.absX.updateUpperBound(this.absY.getUB() - 1, this.aCause);
                    break;
                }
                case 5: {
                    int vx = this.X.getValue();
                    int vz = this.Z.getValue();
                    hasChanged |= this.updateAbsX();
                    hasChanged |= this.updateAbsZ();
                    if (vz != 0 && vx == 0) {
                        this.contradiction(this.X, "");
                    }
                    hasChanged |= this.updateAbsY();
                    break;
                }
                case 6: {
                    int vy = this.Y.getValue();
                    int vz = this.Z.getValue();
                    hasChanged |= this.updateAbsY();
                    hasChanged |= this.updateAbsZ();
                    if (vz == 0) {
                        if (!this.inInterval(this.X, -Math.abs(vy) + 1, Math.abs(vy) - 1)) break;
                        return;
                    }
                    hasChanged |= this.updateAbsX();
                    break;
                }
                case 7: {
                    int vx = this.X.getValue();
                    int vy = this.Y.getValue();
                    int vz = this.Z.getValue();
                    int val = vx / vy;
                    if (vz != val) {
                        this.contradiction(this.Z, "");
                        break;
                    }
                    return;
                }
            }
            if (this.absX.getUB() < this.absY.getLB()) {
                hasChanged |= this.Z.instantiateTo(0, this.aCause);
                continue;
            }
            if (this.X.getLB() > 0 && this.absX.getLB() >= this.absY.getUB()) {
                hasChanged |= this.sameSign(this.Z, this.Y);
                hasChanged |= this.sameSign(this.Y, this.Z);
                continue;
            }
            if (this.X.getUB() >= 0 || this.absX.getLB() < this.absY.getUB()) continue;
            hasChanged |= this.oppSign(this.Z, this.Y);
            hasChanged |= this.oppSign(this.Y, this.Z);
        } while (hasChanged);
    }

    @Override
    public ESat isEntailed() {
        boolean neg;
        boolean pos;
        if (this.Y.isInstantiatedTo(0)) {
            return ESat.FALSE;
        }
        if (this.X.isInstantiatedTo(0) && !this.Z.contains(0)) {
            return ESat.FALSE;
        }
        boolean bl = pos = this.X.getLB() >= 0 && this.Y.getLB() >= 0 || this.X.getUB() < 0 && this.Y.getUB() < 0;
        if (pos && this.Z.getUB() < 0) {
            return ESat.FALSE;
        }
        boolean bl2 = neg = this.X.getLB() >= 0 && this.Y.getUB() < 0 || this.X.getUB() < 0 && this.Y.getLB() >= 0;
        if (neg && this.Z.getLB() > 0) {
            return ESat.FALSE;
        }
        int minAbsX = this.X.getLB() > 0 ? this.X.getLB() : (this.X.getUB() < 0 ? -this.X.getUB() : 0);
        int maxAbsX = Math.max(this.X.getUB(), -this.X.getLB());
        int minAbsY = this.Y.getLB() > 0 ? this.Y.getLB() : (this.Y.getUB() < 0 ? -this.Y.getUB() : 1);
        int maxAbsY = Math.max(this.Y.getUB(), -this.Y.getLB());
        int minAbsZ = this.Z.getLB() > 0 ? this.Z.getLB() : (this.Z.getUB() < 0 ? -this.Z.getUB() : 0);
        int maxAbsZ = Math.max(this.Z.getUB(), -this.Z.getLB());
        if (minAbsZ > maxAbsX / minAbsY || maxAbsZ < minAbsX / maxAbsY) {
            return ESat.FALSE;
        }
        if (this.Z.isInstantiatedTo(0) && minAbsX > maxAbsY || maxAbsX < minAbsY && !this.Z.contains(0)) {
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.eval(this.X.getValue() / this.Y.getValue() == this.Z.getValue());
        }
        return ESat.UNDEFINED;
    }

    private boolean inInterval(IntVar v, int lb, int ub) throws ContradictionException {
        if (v.getLB() >= lb && v.getUB() <= ub) {
            this.setPassive();
            return true;
        }
        if (v.getLB() <= ub && v.getUB() >= lb) {
            v.updateLowerBound(lb, this.aCause);
            v.updateUpperBound(ub, this.aCause);
            this.setPassive();
            return true;
        }
        this.contradiction(v, "");
        return false;
    }

    private boolean outInterval(IntVar v, int lb, int ub) throws ContradictionException {
        if (lb > ub) {
            this.setPassive();
            return true;
        }
        if (lb < ub) {
            if (v.getLB() > ub || v.getUB() < lb) {
                this.setPassive();
                return true;
            }
            if (v.getLB() >= lb && v.getUB() <= ub) {
                this.contradiction(v, "");
            } else {
                if (v.getLB() >= lb) {
                    v.updateLowerBound(ub + 1, this.aCause);
                } else if (v.getUB() <= ub) {
                    v.updateUpperBound(lb - 1, this.aCause);
                }
                this.setPassive();
                return true;
            }
        }
        return false;
    }

    private boolean updateAbsX() throws ContradictionException {
        return this.absX.updateLowerBound(this.absZ.getLB() * this.absY.getLB(), this.aCause) | this.absX.updateUpperBound(this.absZ.getUB() * this.absY.getUB() + this.absY.getUB() - 1, this.aCause);
    }

    private boolean updateAbsY() throws ContradictionException {
        int yub;
        boolean res = this.absZ.getLB() != 0 && this.absY.updateUpperBound((int)Math.floor(this.absX.getUB() / this.absZ.getLB()), this.aCause);
        int zlb = this.absZ.getLB();
        int zub = this.absZ.getUB();
        int xlb = this.absX.getLB();
        int num = xlb - ((yub = this.absY.getUB()) - 1);
        res = num >= 0 && zub != 0 ? (res |= this.absY.updateLowerBound((int)Math.ceil(num / zub), this.aCause)) : (res |= zlb != 0 && this.absY.updateLowerBound(-((int)Math.floor((-xlb + (yub - 1)) / zlb)), this.aCause));
        return res;
    }

    private boolean updateAbsZ() throws ContradictionException {
        boolean res = this.absY.getLB() != 0 && this.absZ.updateUpperBound((int)Math.floor(this.absX.getUB() / this.absY.getLB()), this.aCause);
        int xlb = this.absX.getLB();
        int ylb = this.absY.getLB();
        int yub = this.absY.getUB();
        int num = xlb - (yub - 1);
        res = num >= 0 && yub != 0 ? (res |= this.absZ.updateLowerBound((int)Math.ceil(num / yub), this.aCause)) : (res |= ylb != 0 && this.absZ.updateLowerBound(-((int)Math.floor((-xlb + (yub - 1)) / ylb)), this.aCause));
        return res;
    }

    protected boolean sameSign(IntVar a, IntVar b) throws ContradictionException {
        boolean res = false;
        if (b.getLB() >= 0) {
            res = a.updateLowerBound(0, this.aCause);
        }
        if (b.getUB() <= 0) {
            res |= a.updateUpperBound(0, this.aCause);
        }
        if (!b.contains(0)) {
            res |= a.removeValue(0, this.aCause);
        }
        return res;
    }

    protected boolean oppSign(IntVar a, IntVar b) throws ContradictionException {
        boolean res = false;
        if (b.getLB() >= 0) {
            res = a.updateUpperBound(0, this.aCause);
        }
        if (b.getUB() <= 0) {
            res |= a.updateLowerBound(0, this.aCause);
        }
        if (b.contains(0)) {
            res |= a.removeValue(0, this.aCause);
        }
        return res;
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            ((IntVar[])this.vars)[0].duplicate(solver, identitymap);
            IntVar X = (IntVar)identitymap.get(((IntVar[])this.vars)[0]);
            ((IntVar[])this.vars)[1].duplicate(solver, identitymap);
            IntVar Y = (IntVar)identitymap.get(((IntVar[])this.vars)[1]);
            ((IntVar[])this.vars)[2].duplicate(solver, identitymap);
            IntVar Z = (IntVar)identitymap.get(((IntVar[])this.vars)[2]);
            this.absX.duplicate(solver, identitymap);
            IntVar absX = (IntVar)identitymap.get(this.absX);
            this.absY.duplicate(solver, identitymap);
            IntVar absY = (IntVar)identitymap.get(this.absY);
            this.absZ.duplicate(solver, identitymap);
            IntVar absZ = (IntVar)identitymap.get(this.absZ);
            identitymap.put(this, new PropDivXYZ(X, Y, Z, absX, absY, absZ));
        }
    }
}

