/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.ternary;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public class PropMinBC
extends Propagator<IntVar> {
    IntVar MIN;
    IntVar v1;
    IntVar v2;

    public PropMinBC(IntVar X, IntVar Y, IntVar Z) {
        super((Variable[])new IntVar[]{X, Y, Z}, PropagatorPriority.TERNARY, true);
        this.MIN = ((IntVar[])this.vars)[0];
        this.v1 = ((IntVar[])this.vars)[1];
        this.v2 = ((IntVar[])this.vars)[2];
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.filter();
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        this.propagate(0);
    }

    private void filter() throws ContradictionException {
        int c = 0;
        c += ((IntVar[])this.vars)[0].isInstantiated() ? 1 : 0;
        c += ((IntVar[])this.vars)[1].isInstantiated() ? 2 : 0;
        switch (c += ((IntVar[])this.vars)[2].isInstantiated() ? 4 : 0) {
            case 6: 
            case 7: {
                ((IntVar[])this.vars)[0].instantiateTo(Math.min(((IntVar[])this.vars)[1].getValue(), ((IntVar[])this.vars)[2].getValue()), this.aCause);
                this.setPassive();
                break;
            }
            case 5: {
                int min = ((IntVar[])this.vars)[0].getValue();
                int val2 = ((IntVar[])this.vars)[2].getValue();
                if (min < val2) {
                    ((IntVar[])this.vars)[1].instantiateTo(min, this.aCause);
                    this.setPassive();
                    break;
                }
                if (min > val2) {
                    this.contradiction(((IntVar[])this.vars)[2], "wrong min selected");
                    break;
                }
                ((IntVar[])this.vars)[1].updateLowerBound(min, this.aCause);
                break;
            }
            case 4: {
                int val = ((IntVar[])this.vars)[2].getValue();
                if (val < ((IntVar[])this.vars)[1].getLB()) {
                    ((IntVar[])this.vars)[0].instantiateTo(val, this.aCause);
                    this.setPassive();
                    break;
                }
                this._filter();
                break;
            }
            case 3: {
                int min = ((IntVar[])this.vars)[0].getValue();
                int val1 = ((IntVar[])this.vars)[1].getValue();
                if (min < val1) {
                    ((IntVar[])this.vars)[2].instantiateTo(min, this.aCause);
                    this.setPassive();
                    break;
                }
                if (min > val1) {
                    this.contradiction(((IntVar[])this.vars)[1], "");
                    break;
                }
                ((IntVar[])this.vars)[2].updateLowerBound(min, this.aCause);
                break;
            }
            case 2: {
                int val = ((IntVar[])this.vars)[1].getValue();
                if (val < ((IntVar[])this.vars)[2].getLB()) {
                    ((IntVar[])this.vars)[0].instantiateTo(val, this.aCause);
                    this.setPassive();
                    break;
                }
                this._filter();
                break;
            }
            case 1: {
                int min = ((IntVar[])this.vars)[0].getValue();
                if (!((IntVar[])this.vars)[1].contains(min) && !((IntVar[])this.vars)[2].contains(min)) {
                    this.contradiction(((IntVar[])this.vars)[0], null);
                }
                if (((IntVar[])this.vars)[1].getLB() > min) {
                    ((IntVar[])this.vars)[2].instantiateTo(min, this.aCause);
                    this.setPassive();
                    break;
                }
                if (((IntVar[])this.vars)[2].getLB() > min) {
                    ((IntVar[])this.vars)[1].instantiateTo(min, this.aCause);
                    this.setPassive();
                    break;
                }
                if (!(((IntVar[])this.vars)[1].updateLowerBound(min, this.aCause) | ((IntVar[])this.vars)[2].updateLowerBound(min, this.aCause))) break;
                this.filter();
                break;
            }
            case 0: {
                this._filter();
            }
        }
    }

    private void _filter() throws ContradictionException {
        boolean change;
        do {
            change = ((IntVar[])this.vars)[0].updateLowerBound(Math.min(((IntVar[])this.vars)[1].getLB(), ((IntVar[])this.vars)[2].getLB()), this.aCause);
            change |= ((IntVar[])this.vars)[0].updateUpperBound(Math.min(((IntVar[])this.vars)[1].getUB(), ((IntVar[])this.vars)[2].getUB()), this.aCause);
            change |= ((IntVar[])this.vars)[1].updateLowerBound(((IntVar[])this.vars)[0].getLB(), this.aCause);
            change |= ((IntVar[])this.vars)[2].updateLowerBound(((IntVar[])this.vars)[0].getLB(), this.aCause);
            if (((IntVar[])this.vars)[2].getLB() > ((IntVar[])this.vars)[0].getUB()) {
                change |= ((IntVar[])this.vars)[1].updateUpperBound(((IntVar[])this.vars)[0].getUB(), this.aCause);
            }
            if (((IntVar[])this.vars)[1].getLB() <= ((IntVar[])this.vars)[0].getUB()) continue;
            change |= ((IntVar[])this.vars)[2].updateUpperBound(((IntVar[])this.vars)[0].getUB(), this.aCause);
        } while (change);
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            if (this.MIN.getValue() != Math.min(this.v1.getValue(), this.v2.getValue())) {
                return ESat.FALSE;
            }
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return this.MIN.toString() + ".MIN(" + this.v1.toString() + "," + this.v2.toString() + ")";
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            ((IntVar[])this.vars)[0].duplicate(solver, identitymap);
            IntVar X = (IntVar)identitymap.get(((IntVar[])this.vars)[0]);
            ((IntVar[])this.vars)[1].duplicate(solver, identitymap);
            IntVar Y = (IntVar)identitymap.get(((IntVar[])this.vars)[1]);
            ((IntVar[])this.vars)[2].duplicate(solver, identitymap);
            IntVar Z = (IntVar)identitymap.get(((IntVar[])this.vars)[2]);
            identitymap.put(this, new PropMinBC(X, Y, Z));
        }
    }
}

