/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.ternary;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public class PropTimesXY
extends Propagator<IntVar> {
    IntVar X;
    IntVar Y;
    IntVar Z;

    public PropTimesXY(IntVar x, IntVar y, IntVar z) {
        super((Variable[])new IntVar[]{x, y, z}, PropagatorPriority.UNARY, false);
        this.X = ((IntVar[])this.vars)[0];
        this.Y = ((IntVar[])this.vars)[1];
        this.Z = ((IntVar[])this.vars)[2];
    }

    @Override
    public final int getPropagationConditions(int vIdx) {
        if (vIdx == 2) {
            return 0;
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public final void propagate(int evtmask) throws ContradictionException {
        if (this.X.getLB() >= 0 && this.Y.getLB() >= 0) {
            this.Z.updateLowerBound(this.X.getLB() * this.Y.getLB(), this.aCause);
            this.Z.updateUpperBound(this.X.getUB() * this.Y.getUB(), this.aCause);
        } else if (this.X.getUB() < 0 && this.Y.getUB() < 0) {
            this.Z.updateLowerBound(this.X.getUB() * this.Y.getUB(), this.aCause);
            this.Z.updateUpperBound(this.X.getLB() * this.Y.getLB(), this.aCause);
        } else if (this.X.getLB() > 0 && this.Y.getUB() < 0 || this.X.getUB() < 0 && this.Y.getLB() > 0) {
            int a = this.X.getLB() * this.Y.getUB();
            int b = this.X.getUB() * this.Y.getLB();
            this.Z.updateLowerBound(Math.min(a, b), this.aCause);
            this.Z.updateUpperBound(Math.max(a, b), this.aCause);
        }
        if (this.X.isInstantiated()) {
            this.instantiated(this.X, this.Y);
        } else if (this.Y.isInstantiated()) {
            this.instantiated(this.Y, this.X);
        }
    }

    @Override
    public final void propagate(int varIdx, int mask) throws ContradictionException {
        this.propagate(0);
    }

    @Override
    public final ESat isEntailed() {
        if (this.X.isInstantiated() && this.Y.isInstantiated() && this.Z.isInstantiated()) {
            return ESat.eval(this.X.getValue() * this.Y.getValue() == this.Z.getValue());
        }
        return ESat.UNDEFINED;
    }

    private void instantiated(IntVar X, IntVar Y) throws ContradictionException {
        if (X.getValue() == 0) {
            this.Z.instantiateTo(0, this.aCause);
            this.setPassive();
        } else if (Y.isInstantiated()) {
            this.Z.instantiateTo(X.getValue() * Y.getValue(), this.aCause);
            this.setPassive();
        } else if (this.Z.isInstantiated()) {
            double a = (double)this.Z.getValue() / (double)X.getValue();
            if (Math.abs(a - (double)Math.round(a)) > 0.001) {
                this.contradiction(this.Z, "");
            }
            Y.instantiateTo((int)Math.round(a), this.aCause);
            this.setPassive();
        } else {
            int a = X.getValue() * Y.getLB();
            int b = X.getValue() * Y.getUB();
            this.Z.updateLowerBound(Math.min(a, b), this.aCause);
            this.Z.updateUpperBound(Math.max(a, b), this.aCause);
        }
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((IntVar[])this.vars).length;
            IntVar[] ivars = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                ivars[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            identitymap.put(this, new PropTimesXY(ivars[0], ivars[1], ivars[2]));
        }
    }
}

