/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.ternary;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public class PropTimesZ
extends Propagator<IntVar> {
    IntVar X;
    IntVar Y;
    IntVar Z;

    public PropTimesZ(IntVar x, IntVar y, IntVar z) {
        super((Variable[])new IntVar[]{x, y, z}, PropagatorPriority.UNARY, false);
        this.X = ((IntVar[])this.vars)[0];
        this.Y = ((IntVar[])this.vars)[1];
        this.Z = ((IntVar[])this.vars)[2];
    }

    @Override
    public final int getPropagationConditions(int vIdx) {
        if (vIdx != 2) {
            return 0;
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public final void propagate(int evtmask) throws ContradictionException {
        if (this.Z.getLB() >= 0) {
            this.positiveOrNul();
            if (this.Z.getUB() == 0) {
                this.nul();
            } else if (this.Z.getLB() > 0) {
                this.positiveStrict();
            }
        } else if (this.Z.getUB() < 0) {
            this.negativeStrict();
        }
        if (this.Z.isInstantiated()) {
            this.instantiated(this.X, this.Y);
            this.instantiated(this.Y, this.X);
        }
        if (this.X.isInstantiated()) {
            this.instantiatedFromXY(this.X, this.Y);
        }
        if (this.Y.isInstantiated()) {
            this.instantiatedFromXY(this.Y, this.X);
        }
    }

    @Override
    public final void propagate(int varIdx, int mask) throws ContradictionException {
        this.propagate(0);
    }

    @Override
    public final ESat isEntailed() {
        if (this.X.isInstantiated() && this.Y.isInstantiated() && this.Z.isInstantiated()) {
            return ESat.eval(this.X.getValue() * this.Y.getValue() == this.Z.getValue());
        }
        return ESat.UNDEFINED;
    }

    private void positiveOrNul() throws ContradictionException {
        if (this.X.getUB() < 0) {
            this.Y.updateUpperBound(0, this.aCause);
        } else if (this.X.getLB() > 0) {
            this.Y.updateLowerBound(0, this.aCause);
        } else if (this.Y.getUB() < 0) {
            this.X.updateUpperBound(0, this.aCause);
        } else if (this.Y.getLB() > 0) {
            this.X.updateLowerBound(0, this.aCause);
        }
    }

    private void positiveStrict() throws ContradictionException {
        if (this.X.getUB() < 0) {
            this.Y.updateUpperBound(-1, this.aCause);
        } else if (this.X.getLB() >= 0) {
            this.X.updateLowerBound(1, this.aCause);
            this.Y.updateLowerBound(1, this.aCause);
        } else if (this.Y.getUB() < 0) {
            this.X.updateUpperBound(-1, this.aCause);
        } else if (this.Y.getLB() >= 0) {
            this.X.updateLowerBound(1, this.aCause);
            this.Y.updateLowerBound(1, this.aCause);
        }
    }

    private void negativeStrict() throws ContradictionException {
        if (this.X.getUB() < 0) {
            this.Y.updateLowerBound(1, this.aCause);
        } else if (this.X.getLB() >= 0) {
            this.X.updateLowerBound(1, this.aCause);
            this.Y.updateUpperBound(-1, this.aCause);
        } else if (this.Y.getUB() < 0) {
            this.X.updateLowerBound(1, this.aCause);
        } else if (this.Y.getLB() >= 0) {
            this.X.updateUpperBound(-1, this.aCause);
            this.Y.updateLowerBound(1, this.aCause);
        }
    }

    private void nul() throws ContradictionException {
        if (!this.X.contains(0)) {
            this.Y.instantiateTo(0, this.aCause);
        } else if (!this.Y.contains(0)) {
            this.X.instantiateTo(0, this.aCause);
        } else if (this.X == this.Y) {
            this.Y.instantiateTo(0, this.aCause);
        }
    }

    private void instantiated(IntVar X, IntVar Y) throws ContradictionException {
        if (X.isInstantiated() && Y.isInstantiated()) {
            if (X.getValue() * Y.getValue() != this.Z.getValue()) {
                this.contradiction(this.Z, "");
            }
        } else if (X.isInstantiated()) {
            if (X.getValue() != 0) {
                double a = (double)this.Z.getValue() / (double)X.getValue();
                if (Math.abs(a - (double)Math.round(a)) > 0.001) {
                    this.contradiction(this.Z, "");
                }
                Y.instantiateTo((int)Math.round(a), this.aCause);
                this.setPassive();
            }
        } else {
            double z = this.Z.getValue();
            if (z >= 0.0) {
                double b;
                double a;
                if (X.getLB() > 0) {
                    a = z / (double)X.getLB();
                    b = z / (double)X.getUB();
                    Y.updateUpperBound((int)a, this.aCause);
                    Y.updateLowerBound((int)Math.ceil(b), this.aCause);
                }
                if (X.getUB() < 0) {
                    a = z / (double)X.getLB();
                    b = z / (double)X.getUB();
                    Y.updateUpperBound((int)a, this.aCause);
                    Y.updateLowerBound((int)b, this.aCause);
                }
            } else {
                double b;
                double a;
                if (X.getLB() > 0) {
                    a = z / (double)X.getLB();
                    b = z / (double)X.getUB();
                    Y.updateLowerBound((int)a, this.aCause);
                    Y.updateUpperBound((int)b, this.aCause);
                }
                if (X.getUB() < 0) {
                    a = z / (double)X.getLB();
                    b = z / (double)X.getUB();
                    Y.updateLowerBound((int)a, this.aCause);
                    Y.updateUpperBound((int)b, this.aCause);
                }
            }
        }
    }

    private void instantiatedFromXY(IntVar v1, IntVar v2) throws ContradictionException {
        int value = v1.getValue();
        int lb = v2.getLB();
        int ub = v2.getUB();
        while (lb <= ub && !this.Z.contains(value * lb)) {
            lb = v2.nextValue(lb);
        }
        v2.updateLowerBound(lb, this.aCause);
        while (lb <= ub && !this.Z.contains(value * ub)) {
            ub = v2.previousValue(ub);
        }
        v2.updateUpperBound(ub, this.aCause);
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            int size = ((IntVar[])this.vars).length;
            IntVar[] ivars = new IntVar[size];
            for (int i = 0; i < size; ++i) {
                ((IntVar[])this.vars)[i].duplicate(solver, identitymap);
                ivars[i] = (IntVar)identitymap.get(((IntVar[])this.vars)[i]);
            }
            identitymap.put(this, new PropTimesZ(ivars[0], ivars[1], ivars[2]));
        }
    }
}

