/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.unary;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public class PropLessOrEqualXC
extends Propagator<IntVar> {
    private final int constant;

    public PropLessOrEqualXC(IntVar var, int cste) {
        super((Variable[])new IntVar[]{var}, PropagatorPriority.UNARY, false);
        this.constant = cste;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (((IntVar[])this.vars)[0].updateUpperBound(this.constant, this.aCause) || ((IntVar[])this.vars)[0].getUB() <= this.constant) {
            this.setPassive();
        }
    }

    @Override
    public ESat isEntailed() {
        if (((IntVar[])this.vars)[0].getUB() <= this.constant) {
            return ESat.TRUE;
        }
        if (((IntVar[])this.vars)[0].getLB() > this.constant) {
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return ((IntVar[])this.vars)[0].getName() + " <= " + this.constant;
    }

    @Override
    public void explain(ExplanationEngine xengine, Deduction d, Explanation e) {
        e.add(xengine.getPropagatorActivation(this));
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            identitymap.put(this, new PropLessOrEqualXC((IntVar)identitymap.get(((IntVar[])this.vars)[0]), this.constant));
        }
    }
}

