/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.unary;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public class PropMemberBound
extends Propagator<IntVar> {
    final int lb;
    final int ub;

    public PropMemberBound(IntVar var, int lb, int ub) {
        super((Variable[])new IntVar[]{var}, PropagatorPriority.UNARY, false);
        this.lb = lb;
        this.ub = ub;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        ((IntVar[])this.vars)[0].updateLowerBound(this.lb, this.aCause);
        ((IntVar[])this.vars)[0].updateUpperBound(this.ub, this.aCause);
        if (this.lb <= ((IntVar[])this.vars)[0].getLB() && this.ub >= ((IntVar[])this.vars)[0].getUB()) {
            this.setPassive();
        }
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    @Override
    public ESat isEntailed() {
        if (((IntVar[])this.vars)[0].getLB() >= this.lb && ((IntVar[])this.vars)[0].getUB() <= this.ub) {
            return ESat.TRUE;
        }
        if (((IntVar[])this.vars)[0].getUB() < this.lb || ((IntVar[])this.vars)[0].getLB() > this.ub) {
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return ((IntVar[])this.vars)[0].getName() + " in [" + this.lb + "," + this.ub + "]";
    }

    @Override
    public void explain(ExplanationEngine xengine, Deduction d, Explanation e) {
        e.add(xengine.getPropagatorActivation(this));
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            identitymap.put(this, new PropMemberBound((IntVar)identitymap.get(((IntVar[])this.vars)[0]), this.lb, this.ub));
        }
    }
}

