/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.unary;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;

public class PropMemberEnum
extends Propagator<IntVar> {
    final TIntHashSet values;

    public PropMemberEnum(IntVar var, int[] values) {
        super((Variable[])new IntVar[]{var}, PropagatorPriority.UNARY, false);
        this.values = new TIntHashSet(values);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int left;
        int right = left = Integer.MIN_VALUE;
        boolean rall = true;
        int ub = ((IntVar[])this.vars)[0].getUB();
        int val = ((IntVar[])this.vars)[0].getLB();
        while (val <= ub) {
            if (!this.values.contains(val)) {
                if (val == right + 1) {
                    right = val;
                } else {
                    if (left > Integer.MIN_VALUE) {
                        rall &= ((IntVar[])this.vars)[0].removeInterval(left, right, this.aCause);
                    }
                    left = right = val;
                }
            }
            val = ((IntVar[])this.vars)[0].nextValue(val);
        }
        if (left > Integer.MIN_VALUE) {
            rall &= ((IntVar[])this.vars)[0].removeInterval(left, right, this.aCause);
        }
        if (rall) {
            this.setPassive();
        }
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        this.propagate(0);
    }

    @Override
    public ESat isEntailed() {
        int nb = 0;
        int ub = ((IntVar[])this.vars)[0].getUB();
        int val = ((IntVar[])this.vars)[0].getLB();
        while (val <= ub) {
            if (this.values.contains(val)) {
                ++nb;
            }
            val = ((IntVar[])this.vars)[0].nextValue(val);
        }
        if (nb == 0) {
            return ESat.FALSE;
        }
        if (nb == ((IntVar[])this.vars)[0].getDomainSize()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return ((IntVar[])this.vars)[0].getName() + " in " + Arrays.toString(this.values.toArray());
    }

    @Override
    public void explain(ExplanationEngine xengine, Deduction d, Explanation e) {
        e.add(xengine.getPropagatorActivation(this));
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            identitymap.put(this, new PropMemberEnum((IntVar)identitymap.get(((IntVar[])this.vars)[0]), this.values.toArray()));
        }
    }
}

