/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.unary;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;

public class PropNotEqualXC
extends Propagator<IntVar> {
    private final int constant;

    public PropNotEqualXC(IntVar var, int cste) {
        super((Variable[])new IntVar[]{var}, PropagatorPriority.UNARY, false);
        this.constant = cste;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (((IntVar[])this.vars)[0].removeValue(this.constant, this.aCause) || !((IntVar[])this.vars)[0].contains(this.constant)) {
            this.setPassive();
        }
    }

    @Override
    public ESat isEntailed() {
        if (((IntVar[])this.vars)[0].isInstantiatedTo(this.constant)) {
            return ESat.FALSE;
        }
        if (((IntVar[])this.vars)[0].contains(this.constant)) {
            return ESat.UNDEFINED;
        }
        return ESat.TRUE;
    }

    @Override
    public String toString() {
        return ((IntVar[])this.vars)[0].getName() + " =/= " + this.constant;
    }

    @Override
    public void explain(ExplanationEngine xengine, Deduction d, Explanation e) {
        e.add(xengine.getPropagatorActivation(this));
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            identitymap.put(this, new PropNotEqualXC((IntVar)identitymap.get(((IntVar[])this.vars)[0]), this.constant));
        }
    }
}

