/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.unary;

import gnu.trove.map.hash.THashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;

public class PropNotMemberBound
extends Propagator<IntVar> {
    final int lb;
    final int ub;

    public PropNotMemberBound(IntVar var, int lb, int ub) {
        super((Variable[])new IntVar[]{var}, PropagatorPriority.UNARY, true);
        this.lb = lb;
        this.ub = ub;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (((IntVar[])this.vars)[0].removeInterval(this.lb, this.ub, this.aCause) || ((IntVar[])this.vars)[0].getUB() < this.lb || ((IntVar[])this.vars)[0].getLB() > this.ub) {
            this.setPassive();
        }
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        this.propagate(0);
    }

    @Override
    public ESat isEntailed() {
        int UB = ((IntVar[])this.vars)[0].getUB();
        int nb = 0;
        int val = ((IntVar[])this.vars)[0].getLB();
        while (val <= UB) {
            if (val < this.lb || val > this.ub) {
                ++nb;
            }
            val = ((IntVar[])this.vars)[0].nextValue(val);
        }
        if (nb == 0) {
            return ESat.FALSE;
        }
        if (nb == ((IntVar[])this.vars)[0].getDomainSize()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return ((IntVar[])this.vars)[0].getName() + " outside [" + this.lb + "," + this.ub + "]";
    }

    @Override
    public void explain(ExplanationEngine xengine, Deduction d, Explanation e) {
        e.add(xengine.getPropagatorActivation(this));
    }

    @Override
    public void duplicate(Solver solver, THashMap<Object, Object> identitymap) {
        if (!identitymap.containsKey(this)) {
            identitymap.put(this, new PropNotMemberBound((IntVar)identitymap.get(((IntVar[])this.vars)[0]), this.lb, this.ub));
        }
    }
}

