/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.explanations;

import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.List;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.PropagatorActivation;

public class Explanation
extends Deduction {
    public static ThreadLocal<Explanation> SYSTEM = new ThreadLocal<Explanation>(){

        @Override
        protected Explanation initialValue() {
            return new Explanation();
        }
    };
    private List<Deduction> deductions;
    private TIntHashSet did;

    public Explanation() {
        super(Deduction.Type.Exp);
    }

    public void add(Explanation expl) {
        int nbd = expl.nbDeductions();
        if (nbd > 0) {
            for (int i = 0; i < nbd; ++i) {
                this.add(expl.getDeduction(i));
            }
        }
    }

    public void add(Deduction d) {
        if (d.mType == Deduction.Type.Exp) {
            this.add((Explanation)d);
        } else {
            PropagatorActivation pa;
            if (d.getmType() == Deduction.Type.PropAct && (pa = (PropagatorActivation)d).getPropagator().isReifiedAndSilent()) {
                throw new UnsupportedOperationException();
            }
            if (this.deductions == null) {
                this.deductions = new ArrayList<Deduction>(4);
                this.did = new TIntHashSet();
            }
            if (this.did.add(d.id)) {
                this.deductions.add(d);
            }
        }
    }

    public void remove(Deduction d) {
        this.deductions.remove(d);
        this.did.remove(d.id);
    }

    public boolean contain(Deduction d) {
        return this.deductions != null && this.did.contains(d.id);
    }

    public void reset() {
        if (this.deductions != null) {
            this.deductions.clear();
            this.did.clear();
        }
    }

    public int nbDeductions() {
        return this.deductions == null ? 0 : this.deductions.size();
    }

    public Deduction getDeduction(int i) {
        return this.deductions.get(i);
    }

    public String toString() {
        StringBuilder bf = new StringBuilder("E_" + this.id);
        bf.append(" D: ");
        if (this.deductions != null && !this.deductions.isEmpty()) {
            bf.append("(").append(this.deductions.size()).append(") ");
            for (Deduction d : this.deductions) {
                bf.append(d).append(", ");
            }
            if (this.deductions.size() > 1) {
                bf.delete(bf.lastIndexOf(","), bf.length() - 1);
            }
        }
        bf.append(" ;");
        return bf.toString();
    }
}

