/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.explanations;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.FlattenedRecorderExplanationEngine;
import org.chocosolver.solver.explanations.RecorderExplanationEngine;
import org.chocosolver.solver.explanations.ThreadExplanationEngine;
import org.chocosolver.solver.explanations.store.BufferedEventStore;
import org.chocosolver.solver.explanations.store.EventConsumer;
import org.chocosolver.solver.explanations.strategies.ConflictBasedBackjumping;
import org.chocosolver.solver.explanations.strategies.DynamicBacktracking;
import org.chocosolver.solver.search.loop.monitors.IMonitorClose;
import org.chocosolver.solver.search.loop.monitors.IMonitorInitialize;

public abstract class ExplanationFactory
extends Enum<ExplanationFactory> {
    public static final /* enum */ ExplanationFactory NONE = new ExplanationFactory(){

        @Override
        public void plugin(Solver solver, boolean flattened) {
            solver.set(new ExplanationEngine(solver));
        }
    };
    public static final /* enum */ ExplanationFactory CBJ = new ExplanationFactory(){

        @Override
        public void plugin(Solver solver, boolean flattened) {
            2.plugExpl(solver, flattened, false);
            new ConflictBasedBackjumping(solver.getExplainer());
        }
    };
    public static final /* enum */ ExplanationFactory DBT = new ExplanationFactory(){

        @Override
        public void plugin(Solver solver, boolean flattened) {
            3.plugExpl(solver, flattened, false);
            new DynamicBacktracking(solver.getExplainer());
        }
    };
    private static final /* synthetic */ ExplanationFactory[] $VALUES;

    public static ExplanationFactory[] values() {
        return (ExplanationFactory[])$VALUES.clone();
    }

    public static ExplanationFactory valueOf(String name) {
        return Enum.valueOf(ExplanationFactory.class, name);
    }

    public abstract void plugin(Solver var1, boolean var2);

    public static void plugExpl(Solver solver, boolean flattened, boolean thread) {
        assert (solver.getExplainer() == null || !solver.getExplainer().isActive()) : "Explanations are already turn on!";
        ExplanationEngine e = flattened ? new FlattenedRecorderExplanationEngine(solver) : new RecorderExplanationEngine(solver);
        if (thread) {
            final BufferedEventStore eventStore = new BufferedEventStore(e);
            e = new ThreadExplanationEngine(solver, eventStore);
            final EventConsumer[] eventCons = new EventConsumer[1];
            final ExecutorService executor = Executors.newSingleThreadExecutor();
            solver.plugMonitor(new IMonitorInitialize(){

                @Override
                public void beforeInitialize() {
                    eventCons[0] = new EventConsumer(eventStore);
                    executor.submit(eventCons[0]);
                }

                @Override
                public void afterInitialize() {
                }
            });
            solver.plugMonitor(new IMonitorClose(){

                @Override
                public void beforeClose() {
                    eventCons[0].kill();
                    executor.shutdownNow();
                }

                @Override
                public void afterClose() {
                }
            });
        }
        solver.set(e);
    }

    static {
        $VALUES = new ExplanationFactory[]{NONE, CBJ, DBT};
    }
}

