/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.explanations;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.explanations.BranchingDecision;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.PropagatorActivation;
import org.chocosolver.solver.explanations.RecorderExplanationEngine;
import org.chocosolver.solver.explanations.ValueRemoval;
import org.chocosolver.solver.explanations.antidom.AntiDomain;
import org.chocosolver.solver.explanations.store.ArrayEventStore;
import org.chocosolver.solver.explanations.store.IEventStore;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.RootDecision;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;

public class LazyExplanationEngineFromRestart
extends RecorderExplanationEngine {
    final IEventStore estore;

    public LazyExplanationEngineFromRestart(Solver slv) {
        super(slv);
        this.estore = new ArrayEventStore(slv.getEnvironment());
    }

    @Override
    public void beforeInitialPropagation() {
        for (Variable v : this.solver.getVars()) {
            super.getRemovedValues((IntVar)v);
        }
    }

    @Override
    public void removeValue(IntVar var, int val, ICause cause) {
        this.estore.pushEvent(var, cause, IntEventType.REMOVE, val, 0, 0);
    }

    @Override
    public void updateLowerBound(IntVar intVar, int old, int value, ICause cause) {
        this.estore.pushEvent(intVar, cause, IntEventType.INCLOW, old, value, 0);
    }

    @Override
    public void updateUpperBound(IntVar var, int old, int value, ICause cause) {
        this.estore.pushEvent(var, cause, IntEventType.DECUPP, old, value, 0);
    }

    @Override
    public void instantiateTo(IntVar var, int val, ICause cause, int oldLB, int oldUB) {
        this.estore.pushEvent(var, cause, IntEventType.INSTANTIATE, val, oldLB, oldUB);
    }

    @Override
    public void activePropagator(BoolVar var, Propagator propagator) {
        this.estore.pushEvent(var, propagator, PropagatorEventType.FULL_PROPAGATION, 0, 0, 0);
    }

    @Override
    public BranchingDecision getDecision(Decision decision, boolean isLeft) {
        BranchingDecision br = super.getDecision(decision, isLeft);
        if (!isLeft && decision != RootDecision.ROOT) {
            Explanation explanation = (Explanation)this.database.get(br.getId());
            if (explanation == null) {
                explanation = new Explanation();
            } else {
                explanation.reset();
            }
            for (Decision d = decision.getPrevious(); d != RootDecision.ROOT; d = d.getPrevious()) {
                if (!d.hasNext()) continue;
                explanation.add(d.getPositiveDeduction(this));
            }
            this.store(br, explanation);
        }
        return br;
    }

    private void playEvents() {
        this.estore.setUptodate(true);
        int to = this.estore.getSize();
        for (int c = 0; c < to; ++c) {
            int two;
            IntVar var = this.estore.getVariable(c);
            IEventType etype = this.estore.getEventType(c);
            ICause cause = this.estore.getCause(c);
            int one = this.estore.getFirstValue(c);
            boolean bug = true;
            if (etype == IntEventType.REMOVE) {
                super.removeValue(var, one, cause);
                bug = false;
            }
            if (etype == IntEventType.INSTANTIATE) {
                two = this.estore.getSecondValue(c);
                int three = this.estore.getThirdValue(c);
                super.instantiateTo(var, one, cause, two, three);
                bug = false;
            }
            if (etype == IntEventType.INCLOW) {
                two = this.estore.getSecondValue(c);
                super.updateLowerBound(var, one, two, cause);
                bug = false;
            }
            if (etype == IntEventType.DECUPP) {
                two = this.estore.getSecondValue(c);
                super.updateUpperBound(var, one, two, cause);
                bug = false;
            }
            if (etype == PropagatorEventType.FULL_PROPAGATION) {
                Propagator prop = (Propagator)cause;
                BoolVar bVar = (BoolVar)var;
                super.activePropagator(bVar, prop);
                bug = false;
            }
            if (!bug) continue;
            throw new UnsupportedOperationException("Unknown type " + etype);
        }
    }

    @Override
    public AntiDomain getRemovedValues(IntVar v) {
        if (!this.estore.isUptodate()) {
            this.playEvents();
        }
        return super.getRemovedValues(v);
    }

    @Override
    public ValueRemoval getValueRemoval(IntVar var, int val) {
        if (!this.estore.isUptodate()) {
            this.playEvents();
        }
        return super.getValueRemoval(var, val);
    }

    @Override
    public PropagatorActivation getPropagatorActivation(Propagator propagator) {
        if (!this.estore.isUptodate()) {
            this.playEvents();
        }
        return super.getPropagatorActivation(propagator);
    }
}

