/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.explanations;

import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.hash.TIntHashSet;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.explanations.BranchingDecision;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.PropagatorActivation;
import org.chocosolver.solver.explanations.ValueRemoval;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.explanations.antidom.AntiDomain;
import org.chocosolver.solver.search.loop.monitors.IMonitorInitPropagation;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.objects.queues.CircularQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecorderExplanationEngine
extends ExplanationEngine
implements IMonitorInitPropagation {
    static Logger LOGGER = LoggerFactory.getLogger(RecorderExplanationEngine.class);
    TIntObjectHashMap<AntiDomain> removedvalues;
    TIntObjectHashMap<TIntObjectHashMap<ValueRemoval>> valueremovals;
    TIntObjectHashMap<PropagatorActivation> propactivs;
    TIntObjectHashMap<Explanation> database;
    TIntObjectHashMap<TIntObjectHashMap<BranchingDecision>> leftbranchdecisions;
    TIntObjectHashMap<TIntObjectHashMap<BranchingDecision>> rightbranchdecisions;
    protected TIntHashSet expanded = new TIntHashSet();
    protected TIntHashSet toexpand = new TIntHashSet();
    protected CircularQueue<Deduction> pending = new CircularQueue(16);

    public RecorderExplanationEngine(Solver solver) {
        super(solver);
        if (!solver.getSettings().plugExplanationIn()) {
            throw new SolverException("\nExplanations are not plugged in.\nTo activate explanations, create a user.property file at project root directory which contains the following two lines:\n# Enabling explanations:\nPLUG_EXPLANATION=true\n");
        }
        this.removedvalues = new TIntObjectHashMap();
        this.valueremovals = new TIntObjectHashMap();
        this.propactivs = new TIntObjectHashMap();
        this.database = new TIntObjectHashMap();
        this.leftbranchdecisions = new TIntObjectHashMap();
        this.rightbranchdecisions = new TIntObjectHashMap();
        solver.plugMonitor(this);
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void beforeInitialPropagation() {
        for (Variable v : this.solver.getVars()) {
            this.getRemovedValues((IntVar)v);
        }
    }

    @Override
    public void afterInitialPropagation() {
    }

    @Override
    public AntiDomain getRemovedValues(IntVar v) {
        int vid = v.getId();
        AntiDomain toreturn = this.removedvalues.get(vid);
        if (toreturn == null) {
            toreturn = v.antiDomain();
            this.removedvalues.put(vid, toreturn);
            TIntObjectHashMap<ValueRemoval> hm = this.valueremovals.get(vid);
            if (hm == null) {
                hm = new TIntObjectHashMap();
                this.valueremovals.put(vid, hm);
            }
        }
        return toreturn;
    }

    @Override
    public Explanation retrieve(IntVar var, int val) {
        return this.database.get(this.getValueRemoval((IntVar)var, (int)val).id);
    }

    @Override
    public ValueRemoval getValueRemoval(IntVar var, int val) {
        ValueRemoval vr;
        int vid = var.getId();
        TIntObjectHashMap<ValueRemoval> hm = this.valueremovals.get(vid);
        if (hm == null) {
            hm = new TIntObjectHashMap();
            this.valueremovals.put(vid, hm);
        }
        if ((vr = hm.get(val)) == null) {
            vr = new ValueRemoval(var, val);
            this.valueremovals.get(vid).put(val, vr);
        }
        return vr;
    }

    @Override
    public PropagatorActivation getPropagatorActivation(Propagator propagator) {
        int pid = propagator.getId();
        PropagatorActivation pa = this.propactivs.get(pid);
        if (pa == null) {
            pa = new PropagatorActivation(propagator);
            this.propactivs.put(pid, pa);
        }
        return pa;
    }

    @Override
    public BranchingDecision getDecision(Decision decision, boolean isLeft) {
        BranchingDecision vr;
        TIntObjectHashMap<BranchingDecision> mapvar;
        int vid = decision.getDecisionVariable().getId();
        TIntObjectHashMap<BranchingDecision> tIntObjectHashMap = mapvar = isLeft ? this.leftbranchdecisions.get(vid) : this.rightbranchdecisions.get(vid);
        if (mapvar == null) {
            mapvar = new TIntObjectHashMap();
            if (isLeft) {
                if (!decision.hasNext()) {
                    System.out.println(decision);
                    throw new SolverException("Arg!");
                }
                this.leftbranchdecisions.put(vid, mapvar);
            } else {
                this.rightbranchdecisions.put(vid, mapvar);
            }
        }
        if ((vr = mapvar.get(decision.getId())) == null) {
            vr = new BranchingDecision(decision, isLeft);
            mapvar.put(decision.getId(), vr);
        }
        return vr;
    }

    @Override
    public void store(Deduction deduction, Explanation explanation) {
        this.database.put(deduction.id, explanation);
    }

    @Override
    public void removeLeftDecisionFrom(Decision decision, Variable var) {
        this.leftbranchdecisions.get(var.getId()).remove(decision.getId());
    }

    @Override
    public void activePropagator(BoolVar var, Propagator propagator) {
        PropagatorActivation pa = this.getPropagatorActivation(propagator);
        Explanation expl = this.database.get(pa.id);
        if (expl == null) {
            expl = new Explanation();
        } else {
            expl.reset();
        }
        var.explain(this, VariableState.DOM, expl);
        if (LOGGER.isDebugEnabled()) {
            this.onActivatePropagator(propagator, expl);
        }
        this.store(pa, expl);
    }

    private void explainValueRemoval(IntVar var, int val, ICause cause) {
        ValueRemoval vr = this.getValueRemoval(var, val);
        Explanation expl = this.database.get(vr.id);
        if (expl == null) {
            expl = new Explanation();
            this.store(vr, expl);
        } else {
            expl.reset();
        }
        cause.explain(this, vr, expl);
        if (LOGGER.isDebugEnabled()) {
            this.onRemoveValue(var, val, cause, expl);
        }
    }

    @Override
    public void removeValue(IntVar var, int val, ICause cause) {
        assert (cause != null);
        this.explainValueRemoval(var, val, cause);
        AntiDomain invdom = this.getRemovedValues(var);
        invdom.add(val);
    }

    @Override
    public void updateLowerBound(IntVar var, int old, int val, ICause cause) {
        assert (cause != null);
        AntiDomain invdom = this.getRemovedValues(var);
        if (invdom.isEnumerated()) {
            for (int v = old; v < val; ++v) {
                if (invdom.get(v)) continue;
                this.explainValueRemoval(var, v, cause);
                invdom.add(v);
            }
        } else if (!invdom.get(--val)) {
            this.explainValueRemoval(var, val, cause);
            invdom.updateLowerBound(old, val + 1);
        }
    }

    @Override
    public void updateUpperBound(IntVar var, int old, int val, ICause cause) {
        assert (cause != null);
        AntiDomain invdom = this.getRemovedValues(var);
        if (invdom.isEnumerated()) {
            for (int v = old; v > val; --v) {
                if (invdom.get(v)) continue;
                this.explainValueRemoval(var, v, cause);
                invdom.add(v);
            }
        } else if (!invdom.get(++val)) {
            this.explainValueRemoval(var, val, cause);
            invdom.updateUpperBound(old, val - 1);
        }
    }

    @Override
    public void instantiateTo(IntVar var, int val, ICause cause, int oldLB, int oldUB) {
        AntiDomain invdom = this.getRemovedValues(var);
        if (invdom.isEnumerated()) {
            int v;
            for (v = oldLB; v < val; ++v) {
                if (invdom.get(v)) continue;
                this.explainValueRemoval(var, v, cause);
                invdom.add(v);
            }
            for (v = oldUB; v > val; --v) {
                if (invdom.get(v)) continue;
                this.explainValueRemoval(var, v, cause);
                invdom.add(v);
            }
        } else if (val < oldLB) {
            this.explainValueRemoval(var, oldLB, cause);
            invdom.updateUpperBound(oldUB, oldLB - 1);
        } else if (val > oldUB) {
            this.explainValueRemoval(var, oldUB, cause);
            invdom.updateLowerBound(oldLB, oldUB + 1);
        } else {
            if (val > oldLB && !invdom.get(val)) {
                this.explainValueRemoval(var, val - 1, cause);
                invdom.updateLowerBound(oldLB, val);
            }
            if (val < oldUB && !invdom.get(val)) {
                this.explainValueRemoval(var, val + 1, cause);
                invdom.updateUpperBound(oldUB, val);
            }
        }
    }

    @Override
    public Explanation flatten(Explanation expl) {
        Deduction ded;
        Explanation toreturn = new Explanation();
        this.expanded.clear();
        this.toexpand.clear();
        this.pending.clear();
        int nbd = expl.nbDeductions();
        for (int i = 0; i < nbd; ++i) {
            ded = expl.getDeduction(i);
            this.pending.addLast(ded);
            this.toexpand.add(ded.id);
        }
        while (!this.pending.isEmpty()) {
            ded = this.pending.pollFirst();
            this.toexpand.remove(ded.id);
            this.expanded.add(ded.id);
            Explanation e = this.database.get(ded.id);
            if (e != null) {
                nbd = e.nbDeductions();
                for (int i = 0; i < nbd; ++i) {
                    ded = e.getDeduction(i);
                    if (this.expanded.contains(ded.id) || !this.toexpand.add(ded.id)) continue;
                    this.pending.addLast(ded);
                }
                continue;
            }
            toreturn.add(ded);
        }
        return toreturn;
    }

    @Override
    public Explanation flatten(IntVar var, int val) {
        AntiDomain ad = this.getRemovedValues(var);
        return this.flatten(this.getValueRemoval(var, ad.getKeyValue(val)));
    }

    @Override
    public Explanation flatten(Deduction deduction) {
        Explanation expl = new Explanation();
        expl.add(deduction);
        return this.flatten(expl);
    }

    @Override
    public Deduction explain(IntVar var, int val) {
        AntiDomain ad = this.getRemovedValues(var);
        return this.explain(this.getValueRemoval(var, ad.getKeyValue(val)));
    }

    @Override
    public Deduction explain(Deduction deduction) {
        return deduction;
    }
}

