/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.explanations;

import java.util.concurrent.atomic.AtomicBoolean;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.explanations.BranchingDecision;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.PropagatorActivation;
import org.chocosolver.solver.explanations.ValueRemoval;
import org.chocosolver.solver.explanations.antidom.AntiDomain;
import org.chocosolver.solver.explanations.store.IEventStore;
import org.chocosolver.solver.explanations.store.QueueEventStore;
import org.chocosolver.solver.search.loop.monitors.IMonitorClose;
import org.chocosolver.solver.search.loop.monitors.IMonitorInitPropagation;
import org.chocosolver.solver.search.loop.monitors.IMonitorUpBranch;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunnableExplanationEngine
extends ExplanationEngine
implements Runnable,
IMonitorClose,
IMonitorInitPropagation,
IMonitorUpBranch {
    static Logger LOGGER = LoggerFactory.getLogger(RunnableExplanationEngine.class);
    private final IEventStore estore = new QueueEventStore();
    final ExplanationEngine mainEngine;
    Thread me;
    AtomicBoolean alive;

    public RunnableExplanationEngine(Solver solver, ExplanationEngine eng) {
        super(solver);
        this.mainEngine = eng;
        solver.plugMonitor(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.alive.get()) {
            while (this.estore.getSize() > 0) {
                boolean bug;
                IEventType etype;
                IEventStore iEventStore = this.estore;
                synchronized (iEventStore) {
                    this.estore.popEvent();
                    IntVar var = this.estore.getVariable(0);
                    etype = this.estore.getEventType(0);
                    ICause cause = this.estore.getCause(0);
                    int one = this.estore.getFirstValue(0);
                    int two = this.estore.getSecondValue(0);
                    int three = this.estore.getThirdValue(0);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("GOT {} {} {} {} {}", var, cause, etype, one, two, three);
                    }
                    bug = true;
                    if (etype == IntEventType.REMOVE) {
                        this.mainEngine.removeValue(var, one, cause);
                        bug = false;
                    }
                    if (etype == IntEventType.INSTANTIATE) {
                        this.mainEngine.instantiateTo(var, one, cause, two, three);
                        bug = false;
                    }
                    if (etype == IntEventType.INCLOW) {
                        this.mainEngine.updateLowerBound(var, one, two, cause);
                        bug = false;
                    }
                    if (etype == IntEventType.DECUPP) {
                        this.mainEngine.updateUpperBound(var, one, two, cause);
                        bug = false;
                    }
                    if (etype == PropagatorEventType.FULL_PROPAGATION) {
                        Propagator prop = (Propagator)cause;
                        BoolVar bVar = (BoolVar)var;
                        this.mainEngine.activePropagator(bVar, prop);
                        bug = false;
                    }
                }
                if (!bug) continue;
                throw new UnsupportedOperationException("Unknown type " + etype);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeValue(IntVar var, int val, ICause cause) {
        IEventStore iEventStore = this.estore;
        synchronized (iEventStore) {
            this.estore.pushEvent(var, cause, IntEventType.REMOVE, val, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLowerBound(IntVar intVar, int old, int value, ICause cause) {
        IEventStore iEventStore = this.estore;
        synchronized (iEventStore) {
            this.estore.pushEvent(intVar, cause, IntEventType.INCLOW, old, value, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUpperBound(IntVar var, int old, int value, ICause cause) {
        IEventStore iEventStore = this.estore;
        synchronized (iEventStore) {
            this.estore.pushEvent(var, cause, IntEventType.DECUPP, old, value, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void instantiateTo(IntVar var, int val, ICause cause, int oldLB, int oldUB) {
        IEventStore iEventStore = this.estore;
        synchronized (iEventStore) {
            this.estore.pushEvent(var, cause, IntEventType.INSTANTIATE, val, oldLB, oldUB);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activePropagator(BoolVar var, Propagator propagator) {
        IEventStore iEventStore = this.estore;
        synchronized (iEventStore) {
            this.estore.pushEvent(var, propagator, PropagatorEventType.FULL_PROPAGATION, 0, 0, 0);
        }
    }

    @Override
    public Deduction explain(IntVar var, int val) {
        this.goOrWait();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("explain({}, {}) -- {} ({})", var, val, Thread.currentThread().equals(this.me), this.estore.getSize());
        }
        return this.mainEngine.explain(var, val);
    }

    @Override
    public Deduction explain(Deduction deduction) {
        this.goOrWait();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("explain({}) -- {} ({})", deduction, Thread.currentThread().equals(this.me), this.estore.getSize());
        }
        return this.mainEngine.explain(deduction);
    }

    @Override
    public Explanation flatten(IntVar var, int val) {
        this.goOrWait();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("flatten({}, {}) -- {} ({})", var, val, Thread.currentThread().equals(this.me), this.estore.getSize());
        }
        return this.mainEngine.flatten(var, val);
    }

    @Override
    public Explanation flatten(Explanation expl) {
        this.goOrWait();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("flatten({}) -- {} ({})", expl, Thread.currentThread().equals(this.me), this.estore.getSize());
        }
        return this.mainEngine.flatten(expl);
    }

    @Override
    public Explanation flatten(Deduction deduction) {
        this.goOrWait();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("flatten({}) -- {} ({})", deduction, Thread.currentThread().equals(this.me), this.estore.getSize());
        }
        return this.mainEngine.flatten(deduction);
    }

    @Override
    public Explanation retrieve(IntVar var, int val) {
        this.goOrWait();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("retrieve({}, {}) -- {} ({})", var, val, Thread.currentThread().equals(this.me), this.estore.getSize());
        }
        return this.mainEngine.retrieve(var, val);
    }

    @Override
    public void store(Deduction deduction, Explanation explanation) {
        this.goOrWait();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("store({}, {}) -- {} ({})", deduction, explanation, Thread.currentThread().equals(this.me), this.estore.getSize());
        }
        this.mainEngine.store(deduction, explanation);
    }

    @Override
    public void removeLeftDecisionFrom(Decision decision, Variable var) {
        this.goOrWait();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("removeLeftDecisionFrom({}, {}) -- {} ({})", decision, var, Thread.currentThread().equals(this.me), this.estore.getSize());
        }
        this.mainEngine.removeLeftDecisionFrom(decision, var);
    }

    @Override
    public BranchingDecision getDecision(Decision decision, boolean isLeft) {
        this.goOrWait();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("getDecision({}, {}) -- {} ({})", decision, isLeft, Thread.currentThread().equals(this.me), this.estore.getSize());
        }
        return this.mainEngine.getDecision(decision, isLeft);
    }

    @Override
    public AntiDomain getRemovedValues(IntVar v) {
        this.goOrWait();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("getRemovedValues({}) -- {} ({})", v, Thread.currentThread().equals(this.me), this.estore.getSize());
        }
        AntiDomain ad = this.mainEngine.getRemovedValues(v);
        LoggerFactory.getLogger("test").debug("AD {} : {} >> {}", v, ad, this.estore.getSize());
        return ad;
    }

    @Override
    public ValueRemoval getValueRemoval(IntVar var, int val) {
        this.goOrWait();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("getValueRemoval({},{}) -- {} ({})", var, val, Thread.currentThread().equals(this.me), this.estore.getSize());
        }
        return this.mainEngine.getValueRemoval(var, val);
    }

    @Override
    public PropagatorActivation getPropagatorActivation(Propagator propagator) {
        this.goOrWait();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("getPropagatorActivation({}) -- {} ({})", propagator, Thread.currentThread().equals(this.me), this.estore.getSize());
        }
        return this.mainEngine.getPropagatorActivation(propagator);
    }

    private void goOrWait() {
        if (!Thread.currentThread().equals(this.me)) {
            while (this.estore.getSize() > 0) {
            }
        }
    }

    @Override
    public void beforeClose() {
        this.alive.set(false);
        try {
            this.me.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void afterClose() {
    }

    @Override
    public void beforeInitialPropagation() {
    }

    @Override
    public void afterInitialPropagation() {
        this.alive = new AtomicBoolean(true);
        this.me = new Thread(this);
        this.me.setDaemon(true);
        this.me.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeUpBranch() {
        IEventStore iEventStore = this.estore;
        synchronized (iEventStore) {
            this.estore.clear();
        }
    }

    @Override
    public void afterUpBranch() {
    }
}

