/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.explanations;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.explanations.BranchingDecision;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.PropagatorActivation;
import org.chocosolver.solver.explanations.ValueRemoval;
import org.chocosolver.solver.explanations.antidom.AntiDomain;
import org.chocosolver.solver.explanations.store.BufferedEventStore;
import org.chocosolver.solver.search.loop.monitors.IMonitorDownBranch;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;

public class ThreadExplanationEngine
extends ExplanationEngine
implements IMonitorDownBranch {
    private final BufferedEventStore eventStore;

    public ThreadExplanationEngine(Solver slv, BufferedEventStore eventStore) {
        super(slv);
        this.eventStore = eventStore;
        slv.plugMonitor(this);
    }

    @Override
    public void removeValue(IntVar var, int val, ICause cause) {
        this.eventStore.push(var, cause, IntEventType.REMOVE, val, 0, 0);
    }

    @Override
    public void updateLowerBound(IntVar intVar, int old, int value, ICause cause) {
        this.eventStore.push(intVar, cause, IntEventType.INCLOW, old, value, 0);
    }

    @Override
    public void updateUpperBound(IntVar var, int old, int value, ICause cause) {
        this.eventStore.push(var, cause, IntEventType.DECUPP, old, value, 0);
    }

    @Override
    public void instantiateTo(IntVar var, int val, ICause cause, int oldLB, int oldUB) {
        this.eventStore.push(var, cause, IntEventType.INSTANTIATE, val, oldLB, oldUB);
    }

    @Override
    public void activePropagator(BoolVar var, Propagator propagator) {
        this.eventStore.push(var, propagator, PropagatorEventType.FULL_PROPAGATION, 0, 0, 0);
    }

    @Override
    public void request() {
        this.eventStore.hurryUp();
    }

    @Override
    public AntiDomain getRemovedValues(IntVar v) {
        return this.eventStore.getRemovedValues(v);
    }

    @Override
    public ValueRemoval getValueRemoval(IntVar var, int val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Deduction explain(IntVar var, int val) {
        return this.eventStore.explain(var, val);
    }

    @Override
    public Deduction explain(Deduction deduction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Explanation flatten(IntVar var, int val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Explanation flatten(Explanation expl) {
        return this.eventStore.flatten(expl);
    }

    @Override
    public Explanation flatten(Deduction deduction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Explanation retrieve(IntVar var, int val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BranchingDecision getDecision(Decision decision, boolean isLeft) {
        return this.eventStore.getDecision(decision, isLeft);
    }

    @Override
    public PropagatorActivation getPropagatorActivation(Propagator propagator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void store(Deduction deduction, Explanation explanation) {
        this.eventStore.store(deduction, explanation);
    }

    @Override
    public void removeLeftDecisionFrom(Decision decision, Variable var) {
        this.eventStore.removeLeftDecisionFrom(decision, var);
    }

    @Override
    public void beforeDownLeftBranch() {
        this.eventStore.hurryUp();
    }

    @Override
    public void afterDownLeftBranch() {
    }

    @Override
    public void beforeDownRightBranch() {
        this.eventStore.hurryUp();
    }

    @Override
    public void afterDownRightBranch() {
    }
}

