/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.explanations.antidom;

import org.chocosolver.memory.IStateBitSet;
import org.chocosolver.solver.explanations.antidom.AntiDomain;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;

public class AntiDomBitset
implements AntiDomain {
    private final int offset;
    IStateBitSet domain;
    private DisposableValueIterator _viterator;

    public AntiDomBitset(IntVar A) {
        this.offset = A.getLB();
        this.domain = A.getSolver().getEnvironment().makeBitSet(A.getUB() - this.offset + 1);
        DisposableRangeIterator rin = A.getRangeIterator(true);
        int p = rin.max();
        rin.next();
        while (rin.hasNext()) {
            int c = rin.min();
            for (int i = p + 1; i < c; ++i) {
                this.add(i);
            }
            p = rin.max();
            rin.next();
        }
        rin.dispose();
    }

    @Override
    public void add(int outsideval) {
        int inside = outsideval - this.offset;
        this.domain.set(inside);
    }

    @Override
    public void updateLowerBound(int oldLB, int newLB) {
        for (int i = oldLB; i < newLB; ++i) {
            this.add(i);
        }
    }

    @Override
    public void updateUpperBound(int oldUB, int newUB) {
        for (int i = oldUB; i > newUB; --i) {
            this.add(i);
        }
    }

    @Override
    public boolean get(int outsideval) {
        int inside = outsideval - this.offset;
        return this.domain.get(inside);
    }

    @Override
    public int getKeyValue(int outsideval) {
        return outsideval;
    }

    @Override
    public int size() {
        return this.domain.cardinality();
    }

    @Override
    public DisposableValueIterator getValueIterator() {
        if (this._viterator == null || !this._viterator.isReusable()) {
            this._viterator = new DisposableValueIterator(){
                int value;

                @Override
                public void bottomUpInit() {
                    super.bottomUpInit();
                    this.value = AntiDomBitset.this.domain.nextSetBit(0);
                }

                @Override
                public void topDownInit() {
                    super.topDownInit();
                }

                @Override
                public boolean hasNext() {
                    return this.value != -1;
                }

                @Override
                public boolean hasPrevious() {
                    return this.value != -1;
                }

                @Override
                public int next() {
                    int old = this.value;
                    this.value = AntiDomBitset.this.domain.nextSetBit(this.value + 1);
                    return old + AntiDomBitset.this.offset;
                }

                @Override
                public int previous() {
                    int old = this.value;
                    this.value = AntiDomBitset.this.domain.prevSetBit(this.value - 1);
                    return old + AntiDomBitset.this.offset;
                }
            };
        }
        this._viterator.bottomUpInit();
        return this._viterator;
    }

    public String toString() {
        StringBuilder bf = new StringBuilder();
        bf.append("[");
        DisposableValueIterator it = this.getValueIterator();
        while (it.hasNext()) {
            bf.append(" ").append(it.next());
        }
        it.dispose();
        bf.append("]");
        return bf.toString();
    }

    @Override
    public boolean isEnumerated() {
        return true;
    }
}

