/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.explanations.antidom;

import org.chocosolver.memory.structure.BasicIndexedBipartiteSet;
import org.chocosolver.solver.explanations.antidom.AntiDomain;
import org.chocosolver.solver.variables.impl.BoolVarImpl;
import org.chocosolver.util.iterators.DisposableValueIterator;

public class AntiDomBool
implements AntiDomain {
    protected final int offset;
    protected int mValue;
    protected final BasicIndexedBipartiteSet notInstanciated;
    private DisposableValueIterator _viterator;

    public AntiDomBool(BoolVarImpl var) {
        this.notInstanciated = var.getSolver().getEnvironment().getSharedBipartiteSetForBooleanVars();
        this.offset = this.notInstanciated.add();
        this.mValue = 0;
    }

    @Override
    public void add(int outsideval) {
        if (outsideval == 0 || outsideval == 1) {
            this.notInstanciated.swap(this.offset);
            this.mValue = outsideval;
        }
    }

    @Override
    public void updateLowerBound(int oldLB, int newLB) {
        for (int i = oldLB; i < newLB; ++i) {
            this.add(i);
        }
    }

    @Override
    public void updateUpperBound(int oldUB, int newUB) {
        for (int i = oldUB; i > newUB; --i) {
            this.add(i);
        }
    }

    @Override
    public boolean get(int outsideval) {
        return !this.notInstanciated.contains(this.offset) && this.mValue == outsideval;
    }

    @Override
    public int getKeyValue(int outsideval) {
        return outsideval;
    }

    @Override
    public int size() {
        return this.notInstanciated.contains(this.offset) ? 0 : 1;
    }

    @Override
    public DisposableValueIterator getValueIterator() {
        if (this._viterator == null || !this._viterator.isReusable()) {
            this._viterator = new DisposableValueIterator(){
                boolean next;

                @Override
                public void bottomUpInit() {
                    super.bottomUpInit();
                    this.next = !AntiDomBool.this.notInstanciated.contains(AntiDomBool.this.offset);
                }

                @Override
                public void topDownInit() {
                    super.topDownInit();
                    this.next = !AntiDomBool.this.notInstanciated.contains(AntiDomBool.this.offset);
                }

                @Override
                public boolean hasNext() {
                    return this.next;
                }

                @Override
                public boolean hasPrevious() {
                    return this.next;
                }

                @Override
                public int next() {
                    this.next = false;
                    return AntiDomBool.this.mValue;
                }

                @Override
                public int previous() {
                    this.next = false;
                    return AntiDomBool.this.mValue;
                }
            };
        }
        this._viterator.bottomUpInit();
        return this._viterator;
    }

    @Override
    public boolean isEnumerated() {
        return true;
    }
}

