/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.explanations.antidom;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.explanations.antidom.AntiDomain;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.iterators.DisposableValueIterator;

public class AntiDomInterval
implements AntiDomain {
    int initLB;
    int initUB;
    IStateInt lbidx;
    int[] lbs;
    IStateInt ubidx;
    int[] ubs;
    private DisposableValueIterator _viterator;

    public AntiDomInterval(IntVar A) {
        IEnvironment env = A.getSolver().getEnvironment();
        this.lbidx = env.makeInt(-1);
        this.ubidx = env.makeInt(-1);
        this.initLB = A.getLB();
        this.initUB = A.getUB();
        this.lbs = new int[16];
        this.ubs = new int[16];
    }

    @Override
    public void add(int outsideval) {
        int lbi = this.lbidx.get();
        int ubi = this.ubidx.get();
        if (lbi >= 0 && outsideval == this.lbs[lbi] + 1 || lbi < 0 && outsideval == this.initLB) {
            int id = this.lbidx.add(1);
            this.resizelbs(id + 1);
            this.lbs[id] = outsideval;
        } else if (ubi >= 0 && outsideval == this.ubs[ubi] - 1 || ubi < 0 && outsideval == this.initUB) {
            int id = this.ubidx.add(1);
            this.resizeubs(id + 1);
            this.ubs[id] = outsideval;
        } else {
            throw new SolverException("Unknown value");
        }
    }

    @Override
    public void updateLowerBound(int oldLB, int newLB) {
        int lbi = this.lbidx.get();
        if (lbi < 0 && (lbi >= 0 || oldLB != this.initLB)) {
            throw new SolverException("Unknown value");
        }
        int id = this.lbidx.add(1);
        this.resizelbs(id + 1);
        this.lbs[id] = newLB - 1;
    }

    @Override
    public void updateUpperBound(int oldUB, int newUB) {
        int ubi = this.ubidx.get();
        if (ubi < 0 && (ubi >= 0 || oldUB != this.initUB)) {
            throw new SolverException("Unknown value");
        }
        int id = this.ubidx.add(1);
        this.resizeubs(id + 1);
        this.ubs[id] = newUB + 1;
    }

    private void resizelbs(int capacity) {
        if (this.lbs.length < capacity) {
            int[] tmp = this.lbs;
            this.lbs = new int[tmp.length * 3 / 2 + 1];
            System.arraycopy(tmp, 0, this.lbs, 0, tmp.length);
        }
    }

    private void resizeubs(int capacity) {
        if (this.ubs.length < capacity) {
            int[] tmp = this.ubs;
            this.ubs = new int[tmp.length * 3 / 2 + 1];
            System.arraycopy(tmp, 0, this.ubs, 0, tmp.length);
        }
    }

    @Override
    public boolean get(int outsideval) {
        int lbi = this.lbidx.get();
        if (lbi >= 0 && this.initLB <= outsideval && outsideval <= this.lbs[lbi]) {
            return true;
        }
        int ubi = this.ubidx.get();
        return ubi >= 0 && this.ubs[ubi] <= outsideval && outsideval <= this.initUB;
    }

    private int binarySearchLU(int fromIndex, int toIndex, int key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int UB = this.lbs[mid];
            int LB = this.lbs[mid - 1];
            if (key > UB) {
                low = mid + 1;
                continue;
            }
            if (key < LB) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        throw new SolverException("Cannot found correct interval");
    }

    private int binarySearchUL(int fromIndex, int toIndex, int key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int UB = this.ubs[mid - 1];
            int LB = this.ubs[mid];
            if (key > UB) {
                high = mid - 1;
                continue;
            }
            if (key < LB) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        throw new SolverException("Cannot found correct interval");
    }

    @Override
    public int getKeyValue(int val) {
        int lbi = this.lbidx.get();
        if (lbi >= 0 && this.initLB <= val && val <= this.lbs[lbi]) {
            if (val <= this.lbs[0]) {
                return this.lbs[0];
            }
            int ii = this.binarySearchLU(1, lbi + 1, val);
            assert (val <= this.lbs[ii]);
            return this.lbs[ii];
        }
        int ubi = this.ubidx.get();
        if (ubi >= 0 && this.ubs[ubi] <= val && val <= this.initUB) {
            if (val >= this.ubs[0]) {
                return this.ubs[0];
            }
            int ii = this.binarySearchUL(1, ubi + 1, val);
            assert (val >= this.ubs[ii]);
            return this.ubs[ii];
        }
        return val;
    }

    @Override
    public int size() {
        return this.lbidx.get() + this.ubidx.get() + 2;
    }

    @Override
    public DisposableValueIterator getValueIterator() {
        if (this._viterator == null || !this._viterator.isReusable()) {
            this._viterator = new DisposableValueIterator(){
                int lbi;
                int clbi;
                int ubi;
                int cubi;

                @Override
                public void bottomUpInit() {
                    super.bottomUpInit();
                    this.lbi = AntiDomInterval.this.lbidx.get();
                    this.clbi = 0;
                    this.ubi = AntiDomInterval.this.ubidx.get();
                    this.cubi = 0;
                }

                @Override
                public void topDownInit() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean hasNext() {
                    return this.clbi <= this.lbi || this.cubi <= this.ubi;
                }

                @Override
                public boolean hasPrevious() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int next() {
                    if (this.clbi <= this.lbi) {
                        return AntiDomInterval.this.lbs[this.clbi++];
                    }
                    return AntiDomInterval.this.ubs[this.cubi++];
                }

                @Override
                public int previous() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        this._viterator.bottomUpInit();
        return this._viterator;
    }

    public String toString() {
        StringBuilder bf = new StringBuilder();
        bf.append("[");
        DisposableValueIterator it = this.getValueIterator();
        while (it.hasNext()) {
            bf.append(" ").append(it.next());
        }
        it.dispose();
        bf.append("]");
        return bf.toString();
    }

    @Override
    public boolean isEnumerated() {
        return false;
    }
}

