/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.explanations.store;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.Cause;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.explanations.store.IEventStore;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.IEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayEventStore
implements IEventStore {
    private static final int SIZE = 128;
    private static final Logger LOGGER = LoggerFactory.getLogger(ArrayEventStore.class);
    IntVar[] varChunks;
    ICause[] cauChunks;
    IEventType[] masChunks;
    int[] val1Chunks;
    int[] val2Chunks;
    int[] val3Chunks;
    IStateInt size;
    boolean up2date;

    public ArrayEventStore(IEnvironment env) {
        this.size = env.makeInt(0);
        this.varChunks = new IntVar[128];
        this.cauChunks = new ICause[128];
        this.masChunks = new IEventType[128];
        this.val1Chunks = new int[128];
        this.val2Chunks = new int[128];
        this.val3Chunks = new int[128];
        this.up2date = false;
    }

    @Override
    public void pushEvent(IntVar var, ICause cause, IEventType mask, int one, int two, int three) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("WRITE {} {} {} {} {}", var, cause, mask, one, two, three);
        }
        assert (cause != Cause.Null) : "cause null";
        int idx = this.size.get();
        if (idx >= this.varChunks.length) {
            this.increase();
        }
        this.varChunks[idx] = var;
        this.cauChunks[idx] = cause;
        this.masChunks[idx] = mask;
        this.val1Chunks[idx] = one;
        this.val2Chunks[idx] = two;
        this.val3Chunks[idx] = three;
        this.size.add(1);
        this.up2date = false;
    }

    @Override
    public void popEvent() {
    }

    private void increase() {
        int _size = this.varChunks.length;
        IntVar[] varBigger = new IntVar[_size + 128];
        System.arraycopy(this.varChunks, 0, varBigger, 0, _size);
        this.varChunks = varBigger;
        ICause[] cauBigger = new ICause[_size + 128];
        System.arraycopy(this.cauChunks, 0, cauBigger, 0, _size);
        this.cauChunks = cauBigger;
        IEventType[] masBigger = new IEventType[_size + 128];
        System.arraycopy(this.masChunks, 0, masBigger, 0, _size);
        this.masChunks = masBigger;
        int[] valBigger = new int[_size + 128];
        System.arraycopy(this.val1Chunks, 0, valBigger, 0, _size);
        this.val1Chunks = valBigger;
        valBigger = new int[_size + 128];
        System.arraycopy(this.val2Chunks, 0, valBigger, 0, _size);
        this.val2Chunks = valBigger;
        valBigger = new int[_size + 128];
        System.arraycopy(this.val3Chunks, 0, valBigger, 0, _size);
        this.val3Chunks = valBigger;
    }

    @Override
    public boolean isUptodate() {
        return this.up2date;
    }

    @Override
    public void setUptodate(boolean b) {
        this.up2date = b;
    }

    @Override
    public int getSize() {
        return this.size.get();
    }

    @Override
    public IntVar getVariable(int evt) {
        return this.varChunks[evt];
    }

    @Override
    public IEventType getEventType(int evt) {
        return this.masChunks[evt];
    }

    @Override
    public ICause getCause(int evt) {
        return this.cauChunks[evt];
    }

    @Override
    public int getFirstValue(int evt) {
        return this.val1Chunks[evt];
    }

    @Override
    public int getSecondValue(int evt) {
        return this.val2Chunks[evt];
    }

    @Override
    public int getThirdValue(int evt) {
        return this.val3Chunks[evt];
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

