/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.explanations.store;

import java.util.ArrayDeque;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.explanations.BranchingDecision;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.antidom.AntiDomain;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedEventStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(BufferedEventStore.class);
    private final ExplanationEngine delegate;
    private final ArrayDeque<IntVar> varChunks;
    private final ArrayDeque<ICause> cauChunks;
    private final ArrayDeque<IEventType> masChunks;
    private final ArrayDeque<Integer> val1Chunks;
    private final ArrayDeque<Integer> val2Chunks;
    private final ArrayDeque<Integer> val3Chunks;
    volatile int size;

    public BufferedEventStore(ExplanationEngine receiver) {
        this.delegate = receiver;
        this.varChunks = new ArrayDeque();
        this.cauChunks = new ArrayDeque();
        this.masChunks = new ArrayDeque();
        this.val1Chunks = new ArrayDeque();
        this.val2Chunks = new ArrayDeque();
        this.val3Chunks = new ArrayDeque();
        this.size = 0;
    }

    public synchronized void push(IntVar var, ICause cause, IEventType etype, int one, int two, int three) {
        this.varChunks.addLast(var);
        this.cauChunks.addLast(cause);
        this.masChunks.addLast(etype);
        this.val1Chunks.addLast(one);
        this.val2Chunks.addLast(two);
        this.val3Chunks.addLast(three);
        ++this.size;
        LOGGER.debug("PUSH: <{},{},{},{},{},{}>", var, cause, etype, one, two, three);
    }

    public synchronized void pop() {
        if (this.size > 0) {
            IntVar var = this.varChunks.removeFirst();
            IEventType etype = this.masChunks.removeFirst();
            ICause cause = this.cauChunks.removeFirst();
            int one = this.val1Chunks.removeFirst();
            int two = this.val2Chunks.removeFirst();
            int three = this.val3Chunks.removeFirst();
            LOGGER.debug("POP: <{},{},{},{},{},{}> ({})", var, cause, etype, one, two, three, this.size - 1);
            if (etype == IntEventType.REMOVE) {
                this.delegate.removeValue(var, one, cause);
            } else if (etype == IntEventType.INSTANTIATE) {
                this.delegate.instantiateTo(var, one, cause, two, three);
            } else if (etype == IntEventType.INCLOW) {
                this.delegate.updateLowerBound(var, one, two, cause);
            } else if (etype == IntEventType.DECUPP) {
                this.delegate.updateUpperBound(var, one, two, cause);
            } else if (etype == PropagatorEventType.FULL_PROPAGATION) {
                Propagator prop = (Propagator)cause;
                BoolVar bVar = (BoolVar)var;
                this.delegate.activePropagator(bVar, prop);
            }
            --this.size;
        } else {
            this.notify();
        }
    }

    public Deduction explain(IntVar var, int val) {
        return this.delegate.explain(var, val);
    }

    public Explanation flatten(Explanation expl) {
        return this.delegate.flatten(expl);
    }

    public void store(Deduction deduction, Explanation explanation) {
        this.delegate.store(deduction, explanation);
    }

    public void removeLeftDecisionFrom(Decision decision, Variable var) {
        this.delegate.removeLeftDecisionFrom(decision, var);
    }

    public BranchingDecision getDecision(Decision decision, boolean isLeft) {
        return this.delegate.getDecision(decision, isLeft);
    }

    public AntiDomain getRemovedValues(IntVar v) {
        return this.delegate.getRemovedValues(v);
    }

    public synchronized void hurryUp() {
        LOGGER.debug("hurryUp! {}", (Object)this.size);
        if (this.size > 0) {
            LOGGER.debug("LOCKED hurryUp -> wait");
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                LOGGER.error("{}", ex);
            }
        }
        LOGGER.debug("RUN hurryUp! ");
    }
}

