/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.explanations.store;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.Cause;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.explanations.store.IEventStore;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.IEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkedEventStore
implements IEventStore {
    private static final int CHUNK_SIZE = 128;
    private static final Logger LOGGER = LoggerFactory.getLogger(ChunkedEventStore.class);
    IntVar[][] varChunks;
    ICause[][] cauChunks;
    IEventType[][] masChunks;
    int[][] val1Chunks;
    int[][] val2Chunks;
    int[][] val3Chunks;
    IStateInt curChunk;
    IStateInt nextTop;
    IStateInt size;
    boolean up2date;

    public ChunkedEventStore(IEnvironment env) {
        this.curChunk = env.makeInt(0);
        this.nextTop = env.makeInt(0);
        this.size = env.makeInt(0);
        this.varChunks = new IntVar[1][];
        this.varChunks[0] = new IntVar[128];
        this.cauChunks = new ICause[1][];
        this.cauChunks[0] = new ICause[128];
        this.masChunks = new IEventType[1][];
        this.masChunks[0] = new IEventType[128];
        this.val1Chunks = new int[1][];
        this.val1Chunks[0] = new int[128];
        this.val2Chunks = new int[1][];
        this.val2Chunks[0] = new int[128];
        this.val3Chunks = new int[1][];
        this.val3Chunks[0] = new int[128];
        this.up2date = false;
    }

    @Override
    public void pushEvent(IntVar var, ICause cause, IEventType mask, int one, int two, int three) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("WRITE {} {} {} {} {}", var, cause, mask, one, two, three);
        }
        assert (cause != Cause.Null) : "cause null";
        int currentC = this.curChunk.get();
        int currentI = this.nextTop.add(1);
        if (currentI > 128) {
            int l;
            currentC = this.curChunk.add(1);
            if (currentC == (l = this.varChunks.length)) {
                this.increase(l);
            }
            this.nextTop.set(1);
            currentI = 0;
        } else {
            --currentI;
        }
        this.varChunks[currentC][currentI] = var;
        this.cauChunks[currentC][currentI] = cause;
        this.masChunks[currentC][currentI] = mask;
        this.val1Chunks[currentC][currentI] = one;
        this.val2Chunks[currentC][currentI] = two;
        this.val3Chunks[currentC][currentI] = three;
        this.size.add(1);
        this.up2date = false;
    }

    @Override
    public void popEvent() {
    }

    private void increase(int l) {
        IntVar[][] varBigger = new IntVar[l + 1][];
        System.arraycopy(this.varChunks, 0, varBigger, 0, l);
        varBigger[l] = new IntVar[128];
        this.varChunks = varBigger;
        ICause[][] cauBigger = new ICause[l + 1][];
        System.arraycopy(this.cauChunks, 0, cauBigger, 0, l);
        cauBigger[l] = new ICause[128];
        this.cauChunks = cauBigger;
        IEventType[][] masBigger = new IEventType[l + 1][];
        System.arraycopy(this.masChunks, 0, masBigger, 0, l);
        masBigger[l] = new IEventType[128];
        this.masChunks = masBigger;
        int[][] valBigger = new int[l + 1][];
        System.arraycopy(this.val1Chunks, 0, valBigger, 0, l);
        valBigger[l] = new int[128];
        this.val1Chunks = valBigger;
        valBigger = new int[l + 1][];
        System.arraycopy(this.val2Chunks, 0, valBigger, 0, l);
        valBigger[l] = new int[128];
        this.val2Chunks = valBigger;
        valBigger = new int[l + 1][];
        System.arraycopy(this.val3Chunks, 0, valBigger, 0, l);
        valBigger[l] = new int[128];
        this.val3Chunks = valBigger;
    }

    @Override
    public boolean isUptodate() {
        return this.up2date;
    }

    @Override
    public void setUptodate(boolean b) {
        this.up2date = b;
    }

    @Override
    public int getSize() {
        return this.size.get();
    }

    private int getChunk(int evt) {
        return evt / 128;
    }

    private int getCell(int evt) {
        return evt & 0x7F;
    }

    @Override
    public IntVar getVariable(int evt) {
        return this.varChunks[this.getChunk(evt)][this.getCell(evt)];
    }

    @Override
    public IEventType getEventType(int evt) {
        return this.masChunks[this.getChunk(evt)][this.getCell(evt)];
    }

    @Override
    public ICause getCause(int evt) {
        return this.cauChunks[this.getChunk(evt)][this.getCell(evt)];
    }

    @Override
    public int getFirstValue(int evt) {
        return this.val1Chunks[this.getChunk(evt)][this.getCell(evt)];
    }

    @Override
    public int getSecondValue(int evt) {
        return this.val2Chunks[this.getChunk(evt)][this.getCell(evt)];
    }

    @Override
    public int getThirdValue(int evt) {
        return this.val3Chunks[this.getChunk(evt)][this.getCell(evt)];
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

