/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.explanations.store;

import java.util.ArrayDeque;
import org.chocosolver.solver.Cause;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.explanations.store.IEventStore;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.IEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueEventStore
implements IEventStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueueEventStore.class);
    ArrayDeque<IntVar> varChunks = new ArrayDeque();
    ArrayDeque<ICause> cauChunks = new ArrayDeque();
    ArrayDeque<IEventType> masChunks = new ArrayDeque();
    ArrayDeque<Integer> val1Chunks = new ArrayDeque();
    ArrayDeque<Integer> val2Chunks = new ArrayDeque();
    ArrayDeque<Integer> val3Chunks = new ArrayDeque();
    volatile int size = 0;
    IntVar var;
    ICause cause;
    IEventType mask;
    int v1;
    int v2;
    int v3;
    boolean up2date = false;

    @Override
    public synchronized void pushEvent(IntVar var, ICause cause, IEventType mask, int one, int two, int three) {
        assert (cause != Cause.Null) : "cause null";
        this.varChunks.addLast(var);
        this.cauChunks.addLast(cause);
        this.masChunks.addLast(mask);
        this.val1Chunks.addLast(one);
        this.val2Chunks.addLast(two);
        this.val3Chunks.addLast(three);
        this.up2date = false;
        ++this.size;
    }

    @Override
    public synchronized void popEvent() {
        this.var = this.varChunks.removeFirst();
        this.mask = this.masChunks.removeFirst();
        this.cause = this.cauChunks.removeFirst();
        this.v1 = this.val1Chunks.removeFirst();
        this.v2 = this.val2Chunks.removeFirst();
        this.v3 = this.val3Chunks.removeFirst();
        --this.size;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("READ {} {} {} {} {}", this.var, this.cause, this.mask, this.v1, this.v2, this.v3);
        }
    }

    @Override
    public boolean isUptodate() {
        return this.up2date;
    }

    @Override
    public void setUptodate(boolean b) {
        this.up2date = b;
    }

    @Override
    public synchronized int getSize() {
        return this.size;
    }

    @Override
    public IntVar getVariable(int evt) {
        return this.var;
    }

    @Override
    public IEventType getEventType(int evt) {
        return this.mask;
    }

    @Override
    public ICause getCause(int evt) {
        return this.cause;
    }

    @Override
    public int getFirstValue(int evt) {
        return this.v1;
    }

    @Override
    public int getSecondValue(int evt) {
        return this.v2;
    }

    @Override
    public int getThirdValue(int evt) {
        return this.v3;
    }

    @Override
    public void clear() {
        this.varChunks.clear();
        this.cauChunks.clear();
        this.masChunks.clear();
        this.val1Chunks.clear();
        this.val2Chunks.clear();
        this.val3Chunks.clear();
    }
}

