/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.explanations.strategies;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.explanations.BranchingDecision;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.search.loop.monitors.IMonitorContradiction;
import org.chocosolver.solver.search.loop.monitors.IMonitorSolution;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.RootDecision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConflictBasedBackjumping
implements IMonitorContradiction,
IMonitorSolution {
    static Logger LOGGER = LoggerFactory.getLogger(ConflictBasedBackjumping.class);
    protected ExplanationEngine mExplanationEngine;
    protected Solver mSolver;
    boolean userE;
    protected Explanation lastOne;

    public ConflictBasedBackjumping(ExplanationEngine mExplanationEngine) {
        this.mExplanationEngine = mExplanationEngine;
        this.mSolver = mExplanationEngine.getSolver();
        this.mSolver.getSearchLoop().plugSearchMonitor(this);
    }

    public Solver getSolver() {
        return this.mSolver;
    }

    public void activeUserExplanation(boolean active) {
        if (!this.mSolver.getSettings().enablePropagatorInExplanation()) {
            throw new SolverException("Solver's settings should be modified to allow storing propagators in explanations.");
        }
        this.userE = active;
    }

    public Explanation getUserExplanation() {
        if (this.userE) {
            return this.lastOne;
        }
        throw new SolverException("User explanation is not activated (see #activeUserExplanation).");
    }

    @Override
    public void onContradiction(ContradictionException cex) {
        assert (cex.v != null || cex.c != null) : this.getClass().getName() + ".onContradiction incoherent state";
        this.mExplanationEngine.request();
        Explanation complete = this.mExplanationEngine.flatten(cex.explain(this.mExplanationEngine));
        if (this.userE) {
            this.lastOne = complete;
        }
        if (LOGGER.isDebugEnabled()) {
            this.mExplanationEngine.onContradiction(cex, complete);
        }
        int upto = this.compute(complete, this.mSolver.getEnvironment().getWorldIndex());
        this.mSolver.getSearchLoop().overridePreviousWorld(upto);
        this.updateVRExplainUponbacktracking(upto, complete, cex.c);
    }

    @Override
    public void onSolution() {
        Decision dec;
        for (dec = this.mSolver.getSearchLoop().getLastDecision(); dec != RootDecision.ROOT && !dec.hasNext(); dec = dec.getPrevious()) {
        }
        if (dec != RootDecision.ROOT) {
            Explanation explanation = new Explanation();
            for (Decision d = dec.getPrevious(); d != RootDecision.ROOT; d = d.getPrevious()) {
                if (!d.hasNext()) continue;
                explanation.add(d.getPositiveDeduction(this.mExplanationEngine));
            }
            this.mExplanationEngine.store(dec.getNegativeDeduction(this.mExplanationEngine), explanation);
        }
        this.mSolver.getSearchLoop().overridePreviousWorld(1);
    }

    protected void updateVRExplainUponbacktracking(int nworld, Explanation expl, ICause cause) {
        Decision dec;
        for (dec = this.mSolver.getSearchLoop().getLastDecision(); dec != RootDecision.ROOT && nworld > 1; dec = dec.getPrevious(), --nworld) {
        }
        if (dec != RootDecision.ROOT) {
            if (!dec.hasNext()) {
                throw new UnsupportedOperationException("RecorderExplanationEngine.updateVRExplain should get to a POSITIVE decision:" + dec);
            }
            Deduction left = dec.getPositiveDeduction(this.mExplanationEngine);
            expl.remove(left);
            assert (left.getmType() == Deduction.Type.DecLeft);
            BranchingDecision va = (BranchingDecision)left;
            this.mExplanationEngine.removeLeftDecisionFrom(va.getDecision(), va.getVar());
            Deduction right = dec.getNegativeDeduction(this.mExplanationEngine);
            this.mExplanationEngine.store(right, this.mExplanationEngine.flatten(expl));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("::EXPL:: BACKTRACK on " + dec);
        }
    }

    int compute(Explanation explanation, int currentWorldIndex) {
        int dworld = 0;
        if (explanation.nbDeductions() > 0) {
            for (int d = 0; d < explanation.nbDeductions(); ++d) {
                int world;
                Deduction dec = explanation.getDeduction(d);
                if (dec.getmType() != Deduction.Type.DecLeft || (world = ((BranchingDecision)dec).getDecision().getWorldIndex() + 1) <= dworld) continue;
                dworld = world;
            }
        }
        return 1 + (currentWorldIndex - dworld);
    }
}

