/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.explanations.strategies;

import java.io.Serializable;
import java.util.ArrayDeque;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.strategies.DynamicBacktracking;
import org.chocosolver.solver.search.loop.ISearchLoop;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.variables.IntVar;

public class DecisionsSet
extends Decision<IntVar>
implements Serializable {
    private final DynamicBacktracking dynamicBacktracking;
    private final ArrayDeque<Decision> decision_path;

    public DecisionsSet(DynamicBacktracking dynamicBacktracking) {
        this.dynamicBacktracking = dynamicBacktracking;
        this.decision_path = new ArrayDeque(8);
    }

    public void clearDecisionPath() {
        this.decision_path.clear();
    }

    public void push(Decision dec) {
        this.decision_path.addFirst(dec);
    }

    public void setDecisionToRefute(Decision dec) {
        this.decision_path.addLast(dec);
    }

    @Override
    public IntVar getDecisionVariable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer getDecisionValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public void buildNext() {
    }

    @Override
    public void rewind() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void apply() throws ContradictionException {
        ISearchLoop mSearchLoop = this.dynamicBacktracking.getSolver().getSearchLoop();
        IEnvironment environment = this.dynamicBacktracking.getSolver().getEnvironment();
        Decision dec2ref = this.decision_path.getLast();
        Decision previous = dec2ref.getPrevious();
        int swi = dec2ref.getWorldIndex();
        Decision dec = this.decision_path.pollFirst();
        dec.setPrevious(previous);
        dec.setWorldIndex(swi++);
        mSearchLoop.setLastDecision(dec);
        dec.buildNext();
        dec.apply();
        mSearchLoop.getSMList().afterDownLeftBranch();
        previous = dec;
        while (!this.decision_path.isEmpty()) {
            dec = this.decision_path.pollFirst();
            dec.setPrevious(previous);
            dec.setWorldIndex(swi++);
            mSearchLoop.setLastDecision(dec);
            dec.buildNext();
            mSearchLoop.getSMList().beforeDownLeftBranch();
            environment.worldPush();
            dec.apply();
            mSearchLoop.getSMList().afterDownLeftBranch();
            previous = dec;
        }
    }

    @Override
    public void setPrevious(Decision decision) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Decision getPrevious() {
        return this;
    }

    @Override
    public void free() {
    }

    @Override
    public void reverse() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Deduction getNegativeDeduction(ExplanationEngine xengine) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Deduction getPositiveDeduction(ExplanationEngine xengine) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void explain(ExplanationEngine xengine, Deduction d, Explanation e) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.decision_path.getFirst().toString();
    }
}

