/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.explanations.strategies;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.explanations.BranchingDecision;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.strategies.ConflictBasedBackjumping;
import org.chocosolver.solver.explanations.strategies.DecisionsSet;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.RootDecision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicBacktracking
extends ConflictBasedBackjumping {
    static Logger LOGGER = LoggerFactory.getLogger(DynamicBacktracking.class);
    DecisionsSet cobdec = new DecisionsSet(this);

    public DynamicBacktracking(ExplanationEngine mExplanationEngine) {
        super(mExplanationEngine);
    }

    @Override
    protected void updateVRExplainUponbacktracking(int nworld, Explanation expl, ICause cause) {
        if (cause == this.mSolver.getObjectiveManager()) {
            super.updateVRExplainUponbacktracking(nworld, expl, cause);
        }
        this.cobdec.clearDecisionPath();
        Decision dec = this.mSolver.getSearchLoop().getLastDecision();
        for (int myworld = nworld; dec != RootDecision.ROOT && myworld > 1; dec = dec.getPrevious(), --myworld) {
        }
        Decision jmpBck = dec;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("::EXPL:: WILL BACKTRACK on " + dec);
        }
        for (dec = this.mSolver.getSearchLoop().getLastDecision(); dec != RootDecision.ROOT && nworld > 1; dec = dec.getPrevious(), --nworld) {
            if (!dec.hasNext()) {
                if (this.mExplanationEngine.flatten(dec.getNegativeDeduction(this.mExplanationEngine)).contain(jmpBck.getPositiveDeduction(this.mExplanationEngine))) continue;
                dec.rewind();
                dec.buildNext();
                this.cobdec.push(dec);
                continue;
            }
            dec.rewind();
            this.cobdec.push(dec);
        }
        if (dec != RootDecision.ROOT) {
            if (!dec.hasNext()) {
                throw new UnsupportedOperationException("DynamicBacktracking.updatVRExplain should get to a POSITIVE decision");
            }
            this.cobdec.setDecisionToRefute(dec);
            Deduction left = dec.getPositiveDeduction(this.mExplanationEngine);
            expl.remove(left);
            assert (left.getmType() == Deduction.Type.DecLeft);
            BranchingDecision va = (BranchingDecision)left;
            this.mExplanationEngine.removeLeftDecisionFrom(va.getDecision(), va.getVar());
            Deduction right = dec.getNegativeDeduction(this.mExplanationEngine);
            this.mExplanationEngine.store(right, this.mExplanationEngine.flatten(expl));
            this.mSolver.getSearchLoop().setLastDecision(this.cobdec);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("::EXPL:: BACKTRACK on " + dec);
        }
    }
}

