/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.explanations.strategies;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.BranchingDecision;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.LazyExplanationEngineFromRestart;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.explanations.strategies.ExplanationToolbox;
import org.chocosolver.solver.search.loop.lns.neighbors.ANeighbor;
import org.chocosolver.solver.search.loop.monitors.IMonitorUpBranch;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.RootDecision;
import org.chocosolver.util.tools.StatisticUtils;

public class ExplainingCut
extends ANeighbor
implements IMonitorUpBranch {
    protected final ExplanationEngine mExplanationEngine;
    protected final Random random;
    private ArrayList<Decision> path;
    private BitSet related2cut;
    private BitSet notFrozen;
    private BitSet refuted;
    private BitSet unrelated;
    private boolean forceCft;
    private boolean isTerminated;
    private double nbFixedVariables = 0.0;
    private int nbCall;
    private int limit;
    private final int level;
    private Decision last;
    private final ArrayList<Deduction> tmpDeductions;
    private final Set<Deduction> tmpValueDeductions;

    public ExplainingCut(Solver aSolver, int level, long seed) {
        super(aSolver);
        if (!(aSolver.getExplainer() instanceof LazyExplanationEngineFromRestart)) {
            aSolver.set(new LazyExplanationEngineFromRestart(aSolver));
        }
        this.mExplanationEngine = aSolver.getExplainer();
        this.level = level;
        this.random = new Random(seed);
        this.path = new ArrayList(16);
        this.related2cut = new BitSet(16);
        this.notFrozen = new BitSet(16);
        this.unrelated = new BitSet(16);
        this.refuted = new BitSet(16);
        this.tmpDeductions = new ArrayList(16);
        this.tmpValueDeductions = new HashSet<Deduction>(16);
        this.mSolver.getSearchLoop().plugSearchMonitor(this);
    }

    @Override
    public void recordSolution() {
        this.clonePath();
        this.forceCft = true;
    }

    @Override
    public void fixSomeVariables(ICause cause) throws ContradictionException {
        int i;
        if (this.forceCft) {
            this.explainCut();
            this.nbFixedVariables = this.related2cut.cardinality();
            this.nbCall = 0;
            this.increaseLimit();
        }
        ++this.nbCall;
        this.restrictLess();
        this.notFrozen.clear();
        this.notFrozen.or(this.related2cut);
        while (!this.notFrozen.isEmpty() && (double)this.notFrozen.cardinality() > this.nbFixedVariables) {
            int idx = this.selectVariable();
            this.notFrozen.clear(idx);
        }
        assert (this.mSolver.getSearchLoop().getLastDecision() == RootDecision.ROOT);
        int first = this.notFrozen.nextSetBit(0);
        int n = i = first > -1 ? this.refuted.nextSetBit(first) : first;
        while (i > -1) {
            this.notFrozen.clear(i);
            i = this.refuted.nextSetBit(i + 1);
        }
        this.notFrozen.or(this.unrelated);
        this.last = null;
        int id = this.notFrozen.nextSetBit(0);
        while (id >= 0 && id < this.path.size()) {
            if (this.path.get(id).hasNext()) {
                this.last = this.path.get(id).duplicate();
                if (this.refuted.get(id)) {
                    this.last.buildNext();
                }
                ExplanationToolbox.imposeDecisionPath(this.mSolver, this.last);
            }
            id = this.notFrozen.nextSetBit(id + 1);
        }
    }

    @Override
    public void restrictLess() {
        if (this.nbCall > this.limit) {
            this.nbFixedVariables = this.random.nextDouble() * (double)this.related2cut.cardinality();
            this.increaseLimit();
        }
        this.last = null;
    }

    @Override
    public boolean isSearchComplete() {
        return this.isTerminated;
    }

    @Override
    public void beforeUpBranch() {
    }

    @Override
    public void afterUpBranch() {
        if (this.last != null && this.mSolver.getSearchLoop().getLastDecision().getId() == this.last.getId()) {
            this.mSolver.getSearchLoop().restart();
        }
    }

    private void increaseLimit() {
        long ank = (long)(1.2 * (double)StatisticUtils.binomialCoefficients(this.related2cut.cardinality(), (int)this.nbFixedVariables - 1));
        int step = (int)Math.min(ank, (long)this.level);
        this.limit = this.nbCall + step;
    }

    private int selectVariable() {
        int id = this.notFrozen.nextSetBit(0);
        for (int cc = this.random.nextInt(this.notFrozen.cardinality()); id >= 0 && cc > 0; --cc) {
            id = this.notFrozen.nextSetBit(id + 1);
        }
        return id;
    }

    private void clonePath() {
        for (Decision dec = this.mSolver.getSearchLoop().getLastDecision(); dec != RootDecision.ROOT; dec = dec.getPrevious()) {
            this.addToPath(dec);
        }
        Collections.reverse(this.path);
        int size = this.path.size();
        int i = 0;
        int mid = size >> 1;
        int j = size - 1;
        while (i < mid) {
            boolean bi = this.refuted.get(i);
            this.refuted.set(i, this.refuted.get(j));
            this.refuted.set(j, bi);
            ++i;
            --j;
        }
    }

    private void addToPath(Decision dec) {
        Decision clone = dec.duplicate();
        this.path.add(clone);
        int pos = this.path.size() - 1;
        if (!dec.hasNext()) {
            this.refuted.set(pos);
        }
    }

    private void explainCut() {
        this.forceCft = false;
        this.mSolver.getEnvironment().worldPush();
        try {
            Decision previous = this.mSolver.getSearchLoop().getLastDecision();
            assert (previous == RootDecision.ROOT);
            this.mExplanationEngine.getSolver().getObjectiveManager().postDynamicCut();
            for (int i = 0; i < this.path.size(); ++i) {
                Decision d = this.path.get(i);
                d.setPrevious(previous);
                d.buildNext();
                if (this.refuted.get(i)) {
                    d.buildNext();
                }
                d.apply();
                this.mSolver.propagate();
                previous = d;
            }
            assert (false) : "SHOULD FAIL!";
        }
        catch (ContradictionException cex) {
            if (cex.v != null || cex.c != null) {
                int i;
                this.tmpDeductions.clear();
                this.tmpValueDeductions.clear();
                this.related2cut.clear();
                this.unrelated.clear();
                Explanation expl = new Explanation();
                if (cex.v != null) {
                    cex.v.explain(this.mExplanationEngine, VariableState.DOM, expl);
                } else {
                    cex.c.explain(this.mExplanationEngine, null, expl);
                }
                Explanation complete = this.mExplanationEngine.flatten(expl);
                ExplanationToolbox.extractDecision(complete, this.tmpValueDeductions);
                this.tmpDeductions.addAll(this.tmpValueDeductions);
                if (this.tmpDeductions.isEmpty()) {
                    this.isTerminated = true;
                }
                for (i = 0; i < this.tmpDeductions.size(); ++i) {
                    int idx = this.path.indexOf(((BranchingDecision)this.tmpDeductions.get(i)).getDecision());
                    this.related2cut.set(idx);
                }
                for (i = 0; i < this.path.size(); ++i) {
                    Decision dec = this.path.get(i);
                    boolean forceNext = !dec.hasNext();
                    dec.rewind();
                    if (forceNext) {
                        dec.buildNext();
                    }
                    dec.setPrevious(null);
                }
            }
            throw new UnsupportedOperationException(this.getClass().getName() + ".onContradiction incoherent state");
        }
        this.mSolver.getEnvironment().worldPop();
        this.mSolver.getEngine().flush();
        this.unrelated.andNot(this.related2cut);
        this.unrelated.andNot(this.refuted);
    }
}

