/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.explanations.strategies;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.BranchingDecision;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.LazyExplanationEngineFromRestart;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.explanations.antidom.AntiDomain;
import org.chocosolver.solver.explanations.strategies.ExplanationToolbox;
import org.chocosolver.solver.objective.ObjectiveManager;
import org.chocosolver.solver.search.loop.lns.neighbors.ANeighbor;
import org.chocosolver.solver.search.loop.monitors.IMonitorInitPropagation;
import org.chocosolver.solver.search.loop.monitors.IMonitorUpBranch;
import org.chocosolver.solver.search.restart.GeometricalRestartStrategy;
import org.chocosolver.solver.search.restart.IRestartStrategy;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.RootDecision;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.tools.StatisticUtils;

public class ExplainingObjective
extends ANeighbor
implements IMonitorInitPropagation,
IMonitorUpBranch {
    protected ExplanationEngine mExplanationEngine;
    private ObjectiveManager<IntVar, Integer> om;
    private IntVar objective;
    private int LB;
    private int UB;
    protected final Random random;
    private ArrayList<Decision> path;
    private final ArrayList<Decision> valueDecisions;
    private final TIntArrayList clusters;
    private final IRestartStrategy geo4cluster;
    private int cluster;
    private BitSet related2dom;
    private BitSet notFrozen;
    private BitSet unrelated;
    private BitSet refuted;
    private Decision last;
    private final ArrayList<Deduction> tmpDeductions;
    private final Set<Deduction> tmpValueDeductions;
    private double nbFixedVariables = 0.0;
    private int nbCall;
    private int limit;
    private final int level;

    public ExplainingObjective(Solver aSolver, int level, long seed) {
        super(aSolver);
        this.random = new Random(seed);
        this.level = level;
        if (!(aSolver.getExplainer() instanceof LazyExplanationEngineFromRestart)) {
            aSolver.set(new LazyExplanationEngineFromRestart(aSolver));
        }
        this.mExplanationEngine = aSolver.getExplainer();
        this.path = new ArrayList(16);
        this.valueDecisions = new ArrayList(16);
        this.clusters = new TIntArrayList(16);
        this.related2dom = new BitSet(16);
        this.notFrozen = new BitSet(16);
        this.unrelated = new BitSet(16);
        this.refuted = new BitSet(16);
        this.tmpDeductions = new ArrayList(16);
        this.tmpValueDeductions = new HashSet<Deduction>(16);
        aSolver.plugMonitor(this);
        this.notFrozen = new BitSet(16);
        this.geo4cluster = new GeometricalRestartStrategy(1, 1.2);
        this.mSolver.plugMonitor(this);
    }

    @Override
    public void recordSolution() {
        this.tmpDeductions.clear();
        this.valueDecisions.clear();
        this.clusters.clear();
        this.path.clear();
        this.related2dom.clear();
        this.unrelated.clear();
        this.readAntiDomain();
        this.buildCluster();
        for (int i = 0; i < this.tmpDeductions.size(); ++i) {
            this.valueDecisions.add(((BranchingDecision)this.tmpDeductions.get(i)).getDecision());
        }
        this.clonePath();
        this.cluster = 1;
        this.notFrozen.or(this.related2dom);
        this.nbFixedVariables = this.related2dom.cardinality();
        this.nbCall = 0;
        this.increaseLimit();
    }

    @Override
    public void fixSomeVariables(ICause cause) throws ContradictionException {
        int i;
        if (this.cluster < this.clusters.size()) {
            int k;
            if ((k = this.cluster++) < this.clusters.size()) {
                for (i = this.clusters.get(k - 1); i < this.clusters.get(k); ++i) {
                    Decision dec = this.valueDecisions.get(i);
                    int idx = this.path.indexOf(dec);
                    this.notFrozen.clear(idx);
                }
            }
        } else {
            ++this.nbCall;
            this.restrictLess();
            this.notFrozen.clear();
            this.notFrozen.or(this.related2dom);
            while (!this.notFrozen.isEmpty() && (double)this.notFrozen.cardinality() > this.nbFixedVariables) {
                int idx = this.selectVariable();
                this.notFrozen.clear(idx);
            }
        }
        assert (this.mSolver.getSearchLoop().getLastDecision() == RootDecision.ROOT);
        int first = this.notFrozen.nextSetBit(0);
        int n = i = first > -1 ? this.refuted.nextSetBit(first) : first;
        while (i > -1) {
            this.notFrozen.clear(i);
            i = this.refuted.nextSetBit(i + 1);
        }
        this.notFrozen.or(this.unrelated);
        this.last = null;
        int id = this.notFrozen.nextSetBit(0);
        while (id >= 0 && id < this.path.size()) {
            if (this.path.get(id).hasNext()) {
                this.last = this.path.get(id).duplicate();
                if (this.refuted.get(id)) {
                    this.last.buildNext();
                }
                ExplanationToolbox.imposeDecisionPath(this.mSolver, this.last);
            }
            id = this.notFrozen.nextSetBit(id + 1);
        }
    }

    @Override
    public void restrictLess() {
        if (this.nbCall > this.limit) {
            this.nbFixedVariables = this.random.nextDouble() * (double)this.related2dom.cardinality();
            this.increaseLimit();
        }
        this.last = null;
    }

    @Override
    public boolean isSearchComplete() {
        return false;
    }

    @Override
    public void beforeInitialPropagation() {
    }

    @Override
    public void afterInitialPropagation() {
        this.om = this.mExplanationEngine.getSolver().getObjectiveManager();
        this.objective = this.om.getObjective();
        this.LB = this.objective.getLB();
        this.UB = this.objective.getUB();
    }

    @Override
    public void beforeUpBranch() {
    }

    @Override
    public void afterUpBranch() {
        if (this.last != null && this.mSolver.getSearchLoop().getLastDecision().getId() == this.last.getId()) {
            this.mSolver.getSearchLoop().restart();
        }
    }

    private void increaseLimit() {
        long ank = (long)(1.2 * (double)StatisticUtils.binomialCoefficients(this.related2dom.cardinality(), (int)this.nbFixedVariables - 1));
        int step = (int)Math.min(ank, (long)this.level);
        this.limit = this.nbCall + step;
    }

    private int selectVariable() {
        int id = this.notFrozen.nextSetBit(0);
        for (int cc = this.random.nextInt(this.notFrozen.cardinality()); id >= 0 && cc > 0; --cc) {
            id = this.notFrozen.nextSetBit(id + 1);
        }
        return id;
    }

    private void readAntiDomain() {
        int near;
        int far;
        boolean ismax;
        AntiDomain adObj = this.mExplanationEngine.getRemovedValues(this.objective);
        DisposableValueIterator it = adObj.getValueIterator();
        this.clusters.add(0);
        boolean bl = ismax = this.om.getPolicy() == ResolutionPolicy.MAXIMIZE;
        if (ismax) {
            far = this.UB;
            near = this.objective.getValue() + 1;
            if (far == this.objective.getValue()) {
                return;
            }
        } else {
            far = this.LB;
            near = this.objective.getValue() - 1;
            if (far == this.objective.getValue()) {
                return;
            }
        }
        if (ismax) {
            if (it.hasNext()) {
                int value;
                do {
                    value = it.next();
                } while (it.hasNext() && (value < near || value > far));
                do {
                    this.explainValue(value);
                } while (it.hasNext() && (value = it.next()) >= near);
            }
        } else if (it.hasNext()) {
            int value;
            do {
                value = it.next();
            } while (it.hasNext() && value < far);
            do {
                this.explainValue(value);
            } while (it.hasNext() && (value = it.next()) <= near);
        }
        it.dispose();
    }

    private void explainValue(int value) {
        this.tmpValueDeductions.clear();
        Explanation explanation = new Explanation();
        this.objective.explain(this.mExplanationEngine, VariableState.REM, value, explanation);
        explanation = this.mExplanationEngine.flatten(explanation);
        ExplanationToolbox.extractDecision(explanation, this.tmpValueDeductions);
        assert (this.tmpValueDeductions.size() > 0) : "E(" + value + ") is EMPTY";
        this.tmpValueDeductions.removeAll(this.tmpDeductions);
        if (this.tmpDeductions.addAll(this.tmpValueDeductions)) {
            this.clusters.add(this.tmpDeductions.size());
        }
    }

    private void buildCluster() {
        if (this.clusters.size() > 1) {
            int one = this.clusters.get(1);
            this.clusters.clear();
            this.clusters.add(0);
            this.clusters.add(one);
            int j = 0;
            for (int i = one + 1; i < this.tmpDeductions.size(); i += this.geo4cluster.getNextCutoff(++j)) {
                this.clusters.add(i);
            }
            if (this.clusters.get(this.clusters.size() - 1) != this.tmpDeductions.size() - 1) {
                this.clusters.add(this.tmpDeductions.size() - 1);
            }
        }
    }

    private void clonePath() {
        for (Decision dec = this.mSolver.getSearchLoop().getLastDecision(); dec != RootDecision.ROOT; dec = dec.getPrevious()) {
            this.addToPath(dec);
        }
        Collections.reverse(this.path);
        int size = this.path.size();
        int i = 0;
        int mid = size >> 1;
        int j = size - 1;
        while (i < mid) {
            boolean bi = this.related2dom.get(i);
            this.related2dom.set(i, this.related2dom.get(j));
            this.related2dom.set(j, bi);
            bi = this.unrelated.get(i);
            this.unrelated.set(i, this.unrelated.get(j));
            this.unrelated.set(j, bi);
            bi = this.refuted.get(i);
            this.refuted.set(i, this.refuted.get(j));
            this.refuted.set(j, bi);
            ++i;
            --j;
        }
    }

    private void addToPath(Decision dec) {
        Decision clone = dec.duplicate();
        this.path.add(clone);
        int pos = this.path.size() - 1;
        if (dec.hasNext()) {
            int idx = this.valueDecisions.indexOf(dec);
            if (idx > -1) {
                this.valueDecisions.set(idx, clone);
                this.related2dom.set(pos);
            } else {
                this.unrelated.set(pos);
            }
        } else {
            this.refuted.set(pos);
        }
    }
}

