/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.explanations.strategies;

import java.util.Set;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.objective.ObjectiveManager;
import org.chocosolver.solver.search.strategy.decision.Decision;

enum ExplanationToolbox {


    protected static void extractDecision(Explanation explanation, Set<Deduction> decisions) {
        decisions.clear();
        if (explanation.nbDeductions() > 0) {
            for (int d = 0; d < explanation.nbDeductions(); ++d) {
                Deduction dec = explanation.getDeduction(d);
                if (dec.getmType() != Deduction.Type.DecLeft) continue;
                decisions.add(dec);
            }
        }
    }

    protected static void imposeDecisionPath(Solver aSolver, Decision decision) throws ContradictionException {
        IEnvironment environment = aSolver.getEnvironment();
        ObjectiveManager objectiveManager = aSolver.getObjectiveManager();
        Decision current = aSolver.getSearchLoop().getLastDecision();
        decision.setPrevious(current);
        aSolver.getSearchLoop().setLastDecision(decision);
        environment.worldPush();
        decision.setWorldIndex(environment.getWorldIndex());
        decision.buildNext();
        objectiveManager.apply(decision);
        objectiveManager.postDynamicCut();
    }

    protected static Decision mimic(Decision dec) {
        boolean forceNext;
        Decision clone = dec.duplicate();
        boolean bl = forceNext = !dec.hasNext();
        if (forceNext) {
            clone.buildNext();
        }
        return clone;
    }
}

