/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.explanations.strategies;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.strategies.ExplanationToolbox;
import org.chocosolver.solver.search.loop.lns.neighbors.PropagationGuidedNeighborhood;
import org.chocosolver.solver.search.loop.monitors.IMonitorUpBranch;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperator;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.fast.FastDecision;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.objects.IntCircularQueue;

public class PGN4Explanation
extends PropagationGuidedNeighborhood
implements IMonitorUpBranch {
    IntCircularQueue queue;
    private Decision duplicator;
    private Decision last;

    public PGN4Explanation(Solver solver, IntVar[] vars, long seed, int fgmtSize, int listSize) {
        super(solver, vars, seed, fgmtSize, listSize);
        this.queue = new IntCircularQueue(vars.length);
    }

    @Override
    public void recordSolution() {
        super.recordSolution();
        if (this.duplicator == null) {
            this.duplicator = this.mSolver.getSearchLoop().getLastDecision().duplicate();
        }
    }

    @Override
    public void restrictLess() {
        this.last = null;
        super.restrictLess();
    }

    @Override
    public void fixSomeVariables(ICause cause) throws ContradictionException {
        this.queue.clear();
        this.mSolver.getEnvironment().worldPush();
        super.fixSomeVariables(cause);
        this.mSolver.getEnvironment().worldPop();
        while (!this.queue.isEmpty()) {
            int id = this.queue.pollFirst();
            FastDecision d = (FastDecision)this.duplicator.duplicate();
            d.set(this.vars[id], this.bestSolution[id], DecisionOperator.int_eq);
            this.last = d;
            ExplanationToolbox.imposeDecisionPath(this.mSolver, d);
        }
    }

    @Override
    protected void impose(int id, ICause cause) throws ContradictionException {
        super.impose(id, cause);
        this.queue.addLast(id);
    }

    @Override
    public void beforeUpBranch() {
    }

    @Override
    public void afterUpBranch() {
        if (this.last != null && this.mSolver.getSearchLoop().getLastDecision().getId() == this.last.getId()) {
            this.mSolver.getSearchLoop().restart();
        }
    }
}

