/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.explanations.strategies;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.strategies.ExplanationToolbox;
import org.chocosolver.solver.search.loop.lns.neighbors.RandomNeighborhood;
import org.chocosolver.solver.search.loop.monitors.IMonitorUpBranch;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperator;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.fast.FastDecision;
import org.chocosolver.solver.variables.IntVar;

public class RandomNeighborhood4Explanation
extends RandomNeighborhood
implements IMonitorUpBranch {
    private Decision duplicator;
    private Decision last;

    public RandomNeighborhood4Explanation(Solver aSolver, IntVar[] vars, int level, long seed) {
        super(aSolver, vars, level, seed);
        this.mSolver.plugMonitor(this);
    }

    @Override
    public void recordSolution() {
        super.recordSolution();
        if (this.duplicator == null) {
            this.duplicator = this.mSolver.getSearchLoop().getLastDecision().duplicate();
        }
    }

    @Override
    public void fixSomeVariables(ICause cause) throws ContradictionException {
        this.last = null;
        super.fixSomeVariables(cause);
    }

    @Override
    protected void impose(int id, ICause cause) throws ContradictionException {
        FastDecision d = (FastDecision)this.duplicator.duplicate();
        d.set(this.vars[id], this.bestSolution[id], DecisionOperator.int_eq);
        this.last = d;
        ExplanationToolbox.imposeDecisionPath(this.mSolver, d);
    }

    @Override
    public void restrictLess() {
        this.last = null;
        super.restrictLess();
    }

    @Override
    public void beforeUpBranch() {
    }

    @Override
    public void afterUpBranch() {
        if (this.last != null && this.mSolver.getSearchLoop().getLastDecision().getId() == this.last.getId()) {
            this.mSolver.getSearchLoop().restart();
        }
    }
}

